/*
 * Created on 20.01.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.amsl.hw;

import jwintab.Jwintab;

/**
 * @author sschimke
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HWTabletPCSignal extends Thread implements HWSignalSource {
	
	static {
		//Jwintab.open();
	}

	private static boolean instanceRunning = false;

	private HWSignal signal;
	private int      tabletWidth   = 24570;
	private int      tabletHeight  = 18431;
//	private int      tabletWidth   = 11000;
//	private int      tabletHeight  = 9000;
	private int      tabletXOffset = 0;
	private int      tabletYOffset = 0;
	private int      width         = -1;
	private int      height        = -1;
	private int      timeout       = -1;
	private boolean  ready         = false;
	private int      gapPressure   = 0;
	
	private boolean[] axisAvailable = { true, true, true, false, false, true, true };
	
	/*
	 * Affine transformation for projecting physical tablet coordinates to logical coordinates.
	 * For logical coordinates, the coordinate origin (0,0) is at the top left corner - x increases
	 * from left to right, y increases from top to bottom.
	 * 
	 *        p' = A * p + b
	 * 
	 *   p and p' are points in physical resp. logical coordinate system
	 *   A is a rotation matrix
	 *   b is a translation vector
	 * 
	 * The array "rotation" consists of four rotation matrices and translation vectors.
	 * Each element of the array has following strudcture:
	 *   { A_1_1, A_1_2, A_2_1, A_2_2, b_1, b_2 }
	 * 
	 * TODO description is incorrect and has to be changed
	 */
	private static final int[][] rotation = {
			{  1,  0,  0, -1, 0, 0, 0, 1 }, // landscape format (normal usage as laptop)
			{  0,  1,  1,  0, 0, 0, 0, 0 }, // portrait format (monitor hinge on the left hand side) 
			{ -1,  0,  0,  1, 1, 0, 0, 0 }, // reverse landscape format
			{  0, -1, -1,  0, 0, 1, 1, 0 }  // portrait format (hinge on the right hand side)
	};
	
	private int[] rot = rotation[0];
	private int o = 0; // TODO remove variable and fix getMaxWidth/Height!!!
	
	public HWTabletPCSignal(HWSignal s, int x, int y) throws Throwable {
		if (instanceRunning) throw new Exception("Only one instance of HWTabletPCSignal is allowed to run.");
		
		if (x != -1 && y != -1) {
			tabletWidth  = x;
			tabletHeight = y;
		}

		instanceRunning = true;
		signal          = s;

		signal.setGapPressure(gapPressure);
		signal.setSignalSource(this);
	}

	public void finalize() throws Throwable {
		super.finalize();
		instanceRunning = false;
	}
	
	public boolean isStream() {
		return true;
	}
	
	public boolean isReady() {
		return ready;
	}
	
	public boolean axisAvailable(int a) {
		return axisAvailable[a];
	}

	public void setTabletOffsetAndSize(int x, int y, int w, int h) {
		tabletXOffset = x;
		tabletYOffset = y;
		width = w;
		height = h;
	}
	
	public int getOrientation() {
		return o;
	}
	public void setOrientation(int o) {
		this.o = o;
		rot = rotation[o];
	}

	public int getTimeout() {
		return timeout;
	}
	public void setTimeout(int t) {
		timeout = t;
	}
	
	/**
	 * returns logical width of tablet. depends on tablet orientation (landscape vs. portrait)
	 */
	public int getMaxWidth() {
		return o < 2 ? tabletWidth : tabletHeight;
	}
	/**
	 * returns logical width of tablet. depends on tablet orientation (landscape vs. portrait)
	 */
	public int getMaxHeight() {
		return o > 1 ? tabletWidth : tabletHeight;
	}

	/***
	 * Main-loop of the thread. Reads data from device and writes it into signal object.
	 */
	public void run() {
		int t = Integer.MAX_VALUE;
		while (!ready) {
			int sample[] = new int[HWSignal.AXES_NUMBER];
			
			if (Jwintab.getPacket(sample) > 0) {
				if (sample[HWSignal.AXIS_P] > gapPressure) t = sample[HWSignal.AXIS_TIME];

				int x = sample[HWSignal.AXIS_X];
				int y = sample[HWSignal.AXIS_Y];

				sample[HWSignal.AXIS_X]  = rot[0] * x + rot[1] * y;
				sample[HWSignal.AXIS_Y]  = rot[2] * x + rot[3] * y;

				sample[HWSignal.AXIS_X] += rot[4] * tabletWidth + rot[6] * tabletHeight;
				sample[HWSignal.AXIS_Y] += rot[5] * tabletWidth + rot[7] * tabletHeight;

				sample[HWSignal.AXIS_X] -= tabletXOffset;
				sample[HWSignal.AXIS_Y] -= tabletYOffset;

				if (sample[HWSignal.AXIS_X] < 0 && sample[HWSignal.AXIS_Y] < 0) continue;
				if (width != -1 && sample[HWSignal.AXIS_X] > width) continue;
				if (height != -1 && sample[HWSignal.AXIS_Y] > height) continue;

				signal.addSample(sample);
				//System.out.println("" + sample[0] + " " + sample[1]);
				signal.notifyConsumers(false);
			} else if (timeout > 0 && sample[HWSignal.AXIS_TIME] - t > timeout) {
				ready = true;
			}
		}
	}
	
	public void halt() {
		ready = true;
		instanceRunning = false;
	}
	
	public String getType() {
		return "WinTab)";
	}
}
