/*
 * Created on 25.01.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.amsl.hw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;

import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.JFrame;

/**
 * @author sschimke
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class HWXYSignalViewer extends HWAbstractSignalViewer implements ComponentListener {
	
	private int       inputWidth;
	private int       inputHeight;
	private int       outputWidth;
	private int       outputHeight;
	private double    inOutX;
	private double    inOutY;

	private boolean   interactive  = false;
	
	private boolean   markSamplePoints = true;//false;

	private int       xOld         = -1; // posiotion of the sample point before
	private int       yOld         = -1;
	
	private int[][] fields =
		{ { 10, 10, 100, 100 },
		  { 200, 10, 300, 100 }
		};
	
	//HWSignalSource source;
	
	Image    bgImage = null;

	public HWXYSignalViewer(HWSignal s) {
		super(s);
		HWSignalSource src = signal.getSignalSource();
		setInOut();
		/*
		 * If mouse driver is used to get pen data, subscribe the source for mouse events of this panel
		 */
		if (src.getClass() == HWMouseSignal.class) {
			addMouseListener((MouseListener) src);
			addMouseMotionListener((MouseMotionListener) src);
		}
	}
	
	/**
	 * Sets some variables regarding input and output dimensions and in-out-ratio.
	 */
	public void setInOut() {
		Dimension d  = Toolkit.getDefaultToolkit().getScreenSize();
		outputWidth  = (int) d.getWidth();
		outputHeight = (int) d.getHeight();
		inputWidth   = signal.getSignalSource().getMaxWidth();
		inputHeight  = signal.getSignalSource().getMaxHeight();
		inOutX       = inputWidth  / (double) outputWidth;
		inOutY       = inputHeight / (double) outputHeight;
	}
	
	/**
	 * if true, then inform the signal source about window changings (move, resize, ...)
	 */
	public void setInteractive(boolean i) {
		 interactive = i;
		 for (Component c = this; c != null; c = c.getParent())
			if (JFrame.class.isInstance(c)) {
				c.addComponentListener(this);
				break;
			}
		setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
		componentChanged();
	}
	
	public void setImage(String file) throws Throwable {
		if (file == null) bgImage = null;
		else {
			bgImage = ImageIO.read(new File(file));
		}
		repaint();
	}

	public void update() {
		Graphics g = getGraphics();
		if (g != null) plot(g);
	}

	public void reload() {
		repaint();
	}
	
	public void paint(Graphics g) {
		if (bgImage != null) g.drawImage(bgImage, 0, 0, Color.WHITE, null);
		signalIndex = 0;
		plot(g);
	}

	private void plot(Graphics g) {
		Vector v = signal.getSignalVector();
		for (int l = v.size(); signalIndex < l; ++signalIndex) {
			int[] s = (int[]) v.elementAt(signalIndex);
			if (s[HWSignal.AXIS_P] <= signal.getGapPressure()) {
				xOld = yOld = -1;
				continue;
			}

			int x = (int) (s[HWSignal.AXIS_X] / inOutX);
			int y = (int) (s[HWSignal.AXIS_Y] / inOutY);
			int p = s[HWSignal.AXIS_P];
			
//			if (markSamplePoints) g.drawRect(x - 1, y - 1, 2, 2);
			int r1 = p / 350;
			int r2 = p / 170;
//			if (markSamplePoints) g.fillOval(x - r1, y - r1, r2, r2);
			if (xOld != -1 && yOld != -1) g.drawLine(xOld, yOld, x, y);
			
			xOld = x;
			yOld = y;
		}
	}

	public void componentHidden(ComponentEvent  e) {}
	public void componentMoved(ComponentEvent   e) { componentChanged(); }
	public void componentShown(ComponentEvent   e) { componentChanged(); }
	public void componentResized(ComponentEvent e) { componentChanged(); }
	
	private void componentChanged() {
		setInOut();
		Point p = getLocationOnScreen();
		signal.getSignalSource().setTabletOffsetAndSize((int) (p.x * inOutX), (int) (p.y * inOutY), ((int) (getWidth() * inOutX)), ((int) (getHeight() * inOutY)));
	}
	
}
