function EER(modality, filename)
% computes the Equal Error Rate and give the ROC
% of FAR vs FRR.

load(filename);

lh_len = length(LH);
NoU = size(LH(1).P, 2);

Ge = zeros(lh_len, 1);
Im = zeros(lh_len, NoU-1);

switch modality
    case 'voice'
       for i = 1:lh_len
           Ge(i) = LH(i).P(1, LH(i).u) / LH(i).wor(1);
           Im(i,:) = LH(i).P(1, setdiff(1:NoU, LH(i).u)) / LH(i).wor(1);
       end
       Ge = unique(Ge);                              % some genuines(and impostors) are duplicated and they have the same likelihoods,
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));  % so we discard them here. The same is applied also in the other cases.
    case 'signature'
       for i = 1:lh_len
           Ge(i) = LH(i).P(2, LH(i).u) / LH(i).wor(2);
           Im(i,:) = LH(i).P(2, setdiff(1:NoU, LH(i).u)) / LH(i).wor(2);
       end
       Ge = unique(Ge);
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));
    case 'face'
       for i = 1:lh_len
           Ge(i) = LH(i).P(3, LH(i).u) / LH(i).wor(3);
           Im(i,:) = LH(i).P(3, setdiff(1:NoU, LH(i).u)) / LH(i).wor(3);
       end
       Ge = unique(Ge);
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));
   case 'voicesignature'
       for i = 1:lh_len % there
           P = fusion([(LH(i).P(1, :) / LH(i).wor(1)) ; (LH(i).P(2, :) / LH(i).wor(2))], 'product', 'distribution', 2);
           Ge(i) = P(LH(i).u);
           Im(i,:) = P(setdiff(1:NoU, LH(i).u));
       end
       Ge = unique(Ge);
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));
   case 'voiceface'
       for i = 1:lh_len
           P = fusion([(LH(i).P(1, :) / LH(i).wor(1)) ; (LH(i).P(3, :) / LH(i).wor(3))], 'product', 'distribution', 2);
           Ge(i) = P(LH(i).u);
           Im(i,:) = P(setdiff(1:NoU, LH(i).u));
       end
       Ge = unique(Ge);
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));
   case 'facesignature'
       for i = 1:lh_len
           P = fusion([(LH(i).P(3, :) / LH(i).wor(3)) ; (LH(i).P(2, :) / LH(i).wor(2))], 'product', 'distribution', 2);
           Ge(i) = P(LH(i).u);
           Im(i,:) = P(setdiff(1:NoU, LH(i).u));
       end
       Ge = unique(Ge);
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));
   case 'all'
       for i = 1:lh_len
           P = fusion([(LH(i).P(1, :) / LH(i).wor(1)) ; (LH(i).P(2, :) / LH(i).wor(2)) ; (LH(i).P(3, :) / LH(i).wor(3))], 'product', 'distribution', 2);
           Ge(i) = P(LH(i).u);
           Im(i,:) = P(setdiff(1:NoU, LH(i).u));
       end
       Ge = unique(Ge);                      % the only case that it is not needed, because there are no duplications
       Im = unique(reshape(Im, lh_len*(NoU-1), 1));
end


Ge = log10(Ge);  %  get the log likelihoods
g_len = length(Ge);
Im = log10(Im);
i_len = length(Im);

theta = -30:.002:5;
th_len = length(theta);

for th=1:th_len
  L1 = length(find(Ge>theta(th)));
  L2 = length(find(Im>theta(th)));

  a(th) = 1-L1/g_len;
  b(th) = L2/i_len;
end

% find the eer
[vl,im]=min(abs(a-b));
eer =  (a(im)+b(im))/2;

% Plot DET
%plot(a,b);
%st1 = sprintf('EER: %.2f', eer);
%title(st1);
%xlabel('False Reject Rate');
%ylabel('False Acceptance Rate');

%figure(2);
switch modality
    case 'voice'
        plot(theta,a,'b');hold on; plot(theta,b,'g');
        plot(theta(1:1000:end),a(1:1000:end),'b.');hold on; plot(theta(1:1000:end),b(1:1000:end),'g.');

    case 'signature'
        plot(theta,a,'r');hold on; plot(theta,b,'k');
        plot(theta(1:1000:end),a(1:1000:end),'r*');hold on; plot(theta(1:1000:end),b(1:1000:end),'k*');
    case 'face'
        plot(theta,a,'c');hold on; plot(theta,b,'m');
        plot(theta(1:1000:end),a(1:1000:end),'co');hold on; plot(theta(1:1000:end),b(1:1000:end),'mo');
end
title('Detection Error Tradeoff curve');
xlabel('log-likelihood');
legend('FRR','FAR');
