function w = FisherLD(c1, c2)
% Fisher Linear Discriminant

m1 = mean(c1);
m2 = mean(c2);
[c1r,c1c]=size(c1);
[c2r,c2c]=size(c2);

Sw = cov([c1-repmat(m1,c1r,1);c2-repmat(m2,c2r,1)]);
w = pinv(Sw)*(m1-m2)';
