function X = copmute_mfcc(s, D)

%   Returns the (mel-scale) cepstral feature vectors.
%
%   s : signal (column vector)
%   D : the dimensionality of the feature vectors (without c[0])
%   X : feature vector matrix (in columns)
%


L = length(s);
fs = 16000;

N = floor((L-1)/160);   
n = (0:N-2)*160;
NF=length(n);      % the number of frames

cc = zeros(D, NF);   % (mel-scale) cepstral coefficients
k = 0;
en = zeros(1,NF);

for i = 1:NF    % frame number  
    seg = s(n(i)+1:n(i)+320+1);   % speech segment (20ms)         
    en(i) = seg'*seg;      % enegry of segment
end

threshold = 0.05*max(en);

for i = 1:NF    % frame number  
    seg = s(n(i)+1:n(i)+320+1);   % speech segment (20ms)         
    enrg = seg'*seg;      % enegry of segment
    if enrg > threshold
        k = k + 1;
        c = mfcc(seg, D+1, fs);     % gets coefficients
        cc(:,k) = c(2:D+1)';      % except c[0]
    end
end
cc = cc(:,1:k);
X=cc;
%plot(en);hold on;plot(threshold(ones(1,length(en))));
%X = cc/10;      % <------ expands(shrinks) the feature space ???
