function [D,dec] = fusion(P, method, normali, wh, lab)
% Make the fusion of the modalities
%
% P: scores(probabilities) of the modalities, it is a 3D
%    matrix
% method: sum, product, max rule or else
% normali: the normalization of the scores
% dec: who the speaker is
% wh: 0 for training the normalization methods, 1 for training
%     the classification methods and 2 for classification

[rows, cols, dep] = size(P);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%  Training only for the normalization methods  %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if wh==0
    switch normali
    case 'tanh'
        fusion_train(P,normali);
    end
    return;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%           Make the normalization           %%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
switch normali
case 'nonorm'
    ;
case 'distribution'
    for k = 1:dep
        for i = 1:rows
            S = sum(P(i,:,k));
            P(i,:,k) = P(i,:,k)/S;
        end
    end
case 'minmax'
    M = max(max(max(P)));
    m = min(min(min(P)));
    P = (P-m)/(M-m);
case 'z-score'
    P1 = reshape(P,1,rows*cols*dep);
    m = mean(P1);
    s = std(P1);
    P = (P-m)/s;
case 'doubleSigm'
    load doubleSig;
    ind = find(P<t);
    P(ind) = 1./(1+exp(-2*(P(ind)-t)/r1));
    nind = setdiff(1:rows*cols*dep, ind);
    P(nind) = 1./(1+exp(-2*(P(nind)-t)/r2));
case 'tanh'
    load tanhMS
    P = .5*(tanh(.01*(P-mGH)/sGH)+1);
otherwise
    error('Unknown normalization method');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%   Train and Classify   %%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if wh==1
    fusion_train(P,method, lab);    % Train the classification methods
    return;
elseif wh ==2
    D = fusion_classify(P,method);    % Classify the score vector
    plot(D);
    [m,dec] = max(D);
else
    disp('Wrong option!');
end

