function D = fusion_classify(P, method)
% the classification result of the fusion method
%
% P: the normalized score to be classified

switch method
case 'product'
    D = prod(P,1);
case 'sum'
    D = sum(P,1);
case 'max'
    D = max(P,[],1);
case 'highestRank'
    [rows cols] = size(P);
    D = zeros(1,cols);
    z = 1:cols;
    for i = 1:rows
        [Y I] = sort(P(i,:));
        D(I) = D(I)+z;
    end
case 'linDiscrimF'
    load lda;
    D = w*P;
otherwise
    error('Unknown method');
end


