function fusion_train(P, method, lab)
% the training of the fusion
%
% P: the scores that train the method

[rows, cols, dep] = size(P);

switch method
case 'tanh'
    L = rows*cols*dep;
    P1 = reshape(P,1,L);
    [P2,I] = sort(P1);
%%%%%   Apply the psi function of the paper Ross2005
%    P1(I(floor(.85*L):floor(.92*L))) = repmat(P1(I(floor(.85*L))),1,floor(.85*L):floor(.92*L));
%    P1(I(ceil(.92*L):floor(.97*L))) = P1(I(floor(.85*L)))*(P1(I(floor(.97*L)))-P1(I(ceil(92.*L):floor(.97*L))))  /  (P1(I(floor(.97*L)))-P1(I(floor(.92*L))));
%    P1(I(ceil(.97*L):L)) = zeros(1,length(ceil(.97*L):L));

%    P1(I(floor(.08*L):floor(.15*L))) = repmat(P1(I(floor(.15*L))),1,floor(.08*L):floor(.15*L));
%    P1(I(ceil(.03*L):floor(.08*L))) = P1(I(floor(.15*L)))*(P1(I(floor(.08*L)))-P1(I(ceil(03.*L):floor(.08*L))))  /  (P1(I(floor(.08*L)))-P1(I(floor(.03*L))));
%    P1(I(1:ceil(.03*L))) = zeros(1,length(1:ceil(.03*L)));
    
    mGH = mean(P1(I(floor(.10*L):floor(.90*L))));
    sGH = std(P1(I(floor(.10*L):floor(.90*L))));
    save tanhMS mGH sGH
case 'linDiscrimF'
    c1 = zeros(rows,(cols-1)*dep);
    c2 = zeros(rows,dep);
    for k = 1:dep
        c2(:,k) = P(:,lab(k),k);
        ind = [1:lab(k)-1 lab(k)+1:cols];
        c1(:,(k-1)*(cols-1)+1:k*(cols-1)) = P(:,ind,k);
    end
    w = FisherLD(c1', c2');
    save lda w;
otherwise
    error('Unknown method');
end

