function y = gau(x, m, s)
% evaluate the density of a Gaussian prob

d = length(s);
[wx,lx] = size(x);
y = zeros(1,lx);

ds = det(s);
si = inv(s);

% compute likelihood
normF = 1/sqrt((2*pi)^d*ds);
df = x-m(:,ones(lx,1));
y = -sum(df.*(si*df)/2);
y = normF*exp(y);

