function [P wLH]= getLHs(X, modality, UserName)
%
%
%

switch modality
    case {'voice','signature'}
        [D T] = size(X);

        global userDir;
        cont = dirRetrieval(userDir, 0);
        len = size(cont,1);
        P = zeros(1,len);

        for i = 1:len
            fname = [userDir cont(i).name '\' modality '\mix'];
            load(fname);
    
            a = mix.priors;
            mX = (mix.centres)';
            cX = mix.covars;
            M = length(a);

            X1 = normalize_test(X,mix);
            LH = 0;      % likelihood
            for t = 1:T
                x = X1(:,t);
                p = p_gmm(x, M, a, mX, cX);
                LH = LH + log10(p+realmin);
            end
            P(i) = 10^(LH/T);
        end

        global worldDir;
        fname = [worldDir modality '\mix'];
        load(fname);

        a = mix.priors;
        mX = (mix.centres)';
        cX = mix.covars;
        M = length(a);

        X1 = normalize_test(X,mix);
        LH = 0;      % likelihood
        for t = 1:T
            x = X1(:,t);
            p = p_gmm(x, M, a, mX, cX);
            LH = LH + log10(p+realmin);
        end
        wLH = 10^(LH/T);

    case 'face'
        [D T dum] = size(X);

        global userDir;
        cont = dirRetrieval(userDir, 0);
        len = size(cont,1);
        P = zeros(1,len);

        fname = [userDir UserName '\' modality '\mix'];
        load(fname);
        a = mix.priors;
        mX = (mix.centres)';
        cX = mix.covars;
        M = length(a);

        for i = 1:len
            X1 = normalize_test(reshape(X(:,:,i), size(X,1),size(X,2)), mix);
            LH = 0;      % likelihood
            for t = 1:T
                x = X1(:,t);
                p = p_gmm(x, M, a, mX, cX);
                LH = LH + log10(p+realmin);
            end
            P(i) = 10^(LH/T);
        end

        global worldDir;
        fname = [worldDir modality '\mix'];
        load(fname);

        a = mix.priors;
        mX = (mix.centres)';
        cX = mix.covars;
        M = length(a);

        LH = 0;      % likelihood
        for t = 1:T
            X1 = normalize_test(reshape(X(:,:,i), size(X,1),size(X,2)), mix);
            x = X1(:,t);
            p = p_gmm(x, M, a, mX, cX);
            LH = LH + log10(p+realmin);
        end
        wLH = 10^(LH/T);
end