%GMMB_GENERATEHIST Create histS structure for PDF-value - density quantile mapping.
%
%    histS = GMMB_GENERATEHIST(bayesS, N)
%
%    bayesS   parameters for the distributions to be used
%    N        number of approximation points per class
%
%    This function creates ordered lists of PDF-values of
%    random points generated by given distributions (bayesS).
%    These lists can be used to evaluate distribution density quantiles.
%
%    See gmmb_hist, gmmb_lhood2frac, gmmb_frac2lhood, gmmb_fracthresh
%
% References:
%   [1] Paalanen, P., Kamarainen, J.-K., Ilonen, J., Klviinen, H.,
%    Feature Representation and Discrimination Based on Gaussian Mixture Model
%    Probability Densities - Practices and Algorithms, Research Report 95,
%    Lappeenranta University of Technology, Department of Information
%    Technology, 2005.
%
% Author(s):
%    Pekka Paalanen <pekka.paalanen@lut.fi>
%    Jarmo Ilonen <jarmo.ilonen@lut.fi>
%    Joni Kamarainen <Joni.Kamarainen@lut.fi>
%
% Copyright:
%
%   Bayesian Classifier with Gaussian Mixture Model Pdf
%   functionality is Copyright (C) 2004 by Pekka Paalanen and
%   Joni-Kristian Kamarainen.
%
%   $Name:  $ $Revision: 1.2 $  $Date: 2005/04/14 10:33:34 $
%

function histS = gmmb_generatehist(bayesS, N);

K = size(bayesS,2);

histS = {};

for k = 1:K
	samples = [];
	Mu = bayesS(k).mu;

	for c = 1:size(Mu, 2)
		n = ceil(N*bayesS(k).weight(c));
		if ~isreal(Mu)
			samples = [ samples; ...
			   gmmb_mkcplx(Mu(:,c).', bayesS(k).sigma(:,:,c), n) ];
		else
			samples = [ samples; ...
			   mvnrnd(Mu(:,c).', bayesS(k).sigma(:,:,c), n) ];
		end
	end

	dens = gmmb_pdf( samples, bayesS(k) );
	histS(k) = {sort(dens)};
end
