function [Y mv stdev] = normalize(X)

%
%  Normalization of feature vectors
%  X : contains feature vectors in columns
%

R = X';   % now feature vectors in rows
[NFV D] = size(R);  % NFV : number of feature vectors
m = mean(R);   % mean value
sd = std(R);   % standard deviation

mv = m;  % mean value
stdev = sd;  % standard deviation

%K = (R - repmat(m, NFV, 1))./repmat(sd, NFV, 1);
K = (R)./repmat(sd, NFV, 1);

Y = K';