function p = p_gmm(x, M, a, means, Cov)

%       For one speaker
%
%       x : the sample point
%       M : the number of Gaussians
%       a : the weights, [a1 a2 ... aM]
%       means : the mean vectors, [m1 m2 ... mM]
%       Cov : the covariance matrices,  [C1 C2 ... CM]
%

D = length(x);

b = zeros(M,1);
for i = 1:M
    m = means(:,i);
%     C = diag( Cov(:,i) + eps );
%     C = diag( Cov(:,i) );
    C = Cov(:,:,i);
    %if (cond(C) > 1000)
    %    C = diag(zeros(1,D)+eps)+C;
    %end
    if rcond(C)<10^-15
        C = C + 0.0001*eye(length(C));
    end
    
    b(i,1) = (1/( (2*pi)^(D/2)*(det(C)^(1/2)) )) * exp((-1/2)*(x-m)'*inv(C)*(x-m));
end

p = a * b;
