function splitFiles(ra)
% separate the files in training set and test set
% ra: if 1 selects the files randomly, if 0 the
% train files are first

global voiceDir;
global faceDir;
global signDir;
global userDir;
global trainFaceFeat;

ucont = dirRetrieval(userDir, 0);
ulen = size(ucont,1);
%load(trainFaceFeat);

for i = 1:ulen
    % Read the contents of the respective directory
    vcont = dirRetrieval([voiceDir ucont(i).name '\*.wav'], 1);
    vlen = size(vcont,1);
%    flen = size(stat_users_features(:,:,i), 2);
    scont = dirRetrieval([signDir ucont(i).name '\*.dat'], 1);
    slen = size(scont,1);
    
    if ra == 0
        trnf = 1:ceil(vlen*0.8);
        tstf = setdiff(1:vlen, trnf);
        save([userDir ucont(i).name '\voice\split'], 'trnf', 'tstf'); % the file in which the variables are
                     % saved. It doesn't apply for faces. For faces there
                     % are two different files. One with the train features vectors and
                     % one with the test feature vectors.


%        trnf = 1:ceil(flen*0.8);
%        tstf = setdiff(1:flen, trnf);
%        save([userDir ucont(i).name '\face\split'], 'trnf', 'tstf');
        
        trnf = 1:ceil(slen*0.8);
        tstf = setdiff(1:slen, trnf);
        save([userDir ucont(i).name '\signature\split'], 'trnf', 'tstf');
    elseif ra == 1
        r = rand(1,vlen);
        [r1 k] = sort(r);
        trnf = k(1:ceil(vlen*0.8));
        tstf = setdiff(1:vlen, trnf);
        save([userDir ucont(i).name '\voice\split'], 'trnf', 'tstf');
        
        r = rand(1,flen);
        [r1 k] = sort(r);
        trnf = k(1:ceil(flen*0.8));
        tstf = setdiff(1:flen, trnf);
        save([userDir ucont(i).name '\face\split'], 'trnf', 'tstf');

        r = rand(1,slen);
        [r1 k] = sort(r);
        trnf = k(1:ceil(slen*0.8));
        tstf = setdiff(1:slen, trnf);
        save([userDir ucont(i).name '\signature\split'], 'trnf', 'tstf');
    end
end

