function [P wor] = test(UserNum, UserName, EMalg, modality, whF)
% calculate and returns the likelihoods for each modality
%
% wh: which file is tested. 0 if we want to test
%     all the files.
% modality: It can be one of {voice, signature, face, voicesignature,
%           voiceface, signatureface, all}
% P: every row is a modality's likelihoods score


% Preparing the retrieval of the users
global userDir;
u_cont = dirRetrieval(userDir, 0);
u_len = size(u_cont,1);


switch modality
    case 'voice'
        global voiceDir;
        P = zeros(1,u_len);
        D = 20;            % the dimension of feature vector
        v_cont = dirRetrieval([voiceDir UserName '\*.wav'], 1);
        y = wavread( [voiceDir UserName '\' v_cont(whF).name]);
        X = compute_mfcc(y, D);

        [P wor] = getLHs(X, 'voice'); % compute the likelihoods. It is a dirty function(don't touch it).
%        plot(P);
%        P(1,:) = P(1,:)/sum(P(1,:));

        [m,in]=max(P(1,:));
        disp(['More probable user:  ' u_cont(in).name]);
        
    case 'signature'
        global signDir;
        P = zeros(1,u_len);
        D = 5;            % the dimension of feature vector
        v_cont = dirRetrieval([signDir UserName '\*.dat'], 1);
        [y, gt] =  jonaspar([signDir UserName '\' v_cont(whF).name]);
        X = y;
        
        [P wor]= getLHs(X, 'signature');
%        plot(P);
%        P(1,:) = P(1,:)/sum(P(1,:));

        [m,in]=max(P(1,:));
        disp(['More probable user:  ' u_cont(in).name]);

    case 'face'
        global faceDir;
        global testFaceFeat;
        D = 7;
        load([faceDir testFaceFeat]);
        X = stat_features(1:D, whF:whF+9, UserNum, :);
        X = reshape(X, D, size(X,2), size(X,4));
        [P wor]= getLHs(X, 'face', UserName);
%        plot(P);pause;
%        P(1,:) = P(1,:)/sum(P(1,:));

        [m,in]=max(P(1,:));
        disp(['More probable user  :' u_cont(in).name]);
        
    case 'voicesignature'
        P = zeros(2,u_len);
        wor = zeros(2,1);
        [P(1,:) wor(1)] = test(UserNum, UserName, EMalg, 'voice',whF(1));
        [P(2,:) wor(2)] = test(UserNum, UserName, EMalg, 'signature',whF(2));

        
    case 'voiceface'
        P = zeros(2,u_len);
        wor = zeros(2,1);
        [P(1,:) wor(1)] = test(UserNum, UserName, EMalg, 'voice',whF(1));
        [P(2,:) wor(2)] = test(UserNum, UserName, EMalg, 'face',whF(2));
        
    case 'signatureface'
        P = zeros(2,u_len);
        wor = zeros(2,1);
        [P(1,:) wor(1)] = test(UserNum, UserName, EMalg, 'signature',whF(1));
        [P(2,:) wor(2)] = test(UserNum, UserName, EMalg, 'face',whF(2));
        
    case 'all'
        P = zeros(3,u_len);
        wor = zeros(3,1);
        [P(1,:) wor(1)] = test(UserNum, UserName, EMalg, 'voice',whF(1));
        [P(2,:) wor(2)] = test(UserNum, UserName, EMalg, 'signature',whF(2));
        [P(3,:) wor(3)] = test(UserNum, UserName, EMalg, 'face',whF(3));
end