function testAll(EMalg)
% Verifying every instance of the database
% and save the likelihoods in a mat file.
% 
% 


global userDir;
global voiceDir;
global faceDir;
global signDir;

LH = [];

% Preparing the retrieval of the users
u_cont = dirRetrieval(userDir, 0);
u_len = size(u_cont,1);

for u = 1:u_len
    v_cont = dirRetrieval([voiceDir '*.wav'], 1); % read the speech files
    load([userDir u_cont(u).name '\voice\split']); % determine which files are for testing(throw the tstf matrix)
    v_te = tstf;
    v_len = length(tstf);
    
    s_cont = dirRetrieval([signDir '*.dat'], 1);  % as voice
    load([userDir u_cont(u).name '\signature\split']);
    s_te = tstf;
    s_len = length(tstf);

% for face is not necessary(it is more dirty)
%    if 0
%    f_cont = dirRetrieval([faceDir '*.jpeg'], 1);
%    load([userDir u_cont(u).name '\face\split']);
%    f_te = tstf;
%    f_len = length(tstf);
%    end
    P1 = zeros(v_len, u_len);
    wor1 = zeros(v_len,1);
    for i = 1:v_len         % compute the likelihood of the feature vector(speech) determined by v_te(i)
                            % to belong in 1 or 2 or ... or 47 class. It
                            % also compute the likelihood of the world(universal background).
        [P1(i,:) wor1(i)] = test(u, u_cont(u).name, EMalg, 'voice', v_te(i));
    end
    P2 = zeros(s_len, u_len);
    wor2 = zeros(s_len,1);
    for j = 1:s_len         % as speech
         [P2(j,:) wor2(j)] = test(u, u_cont(u).name, EMalg, 'signature', s_te(j));
    end
    P3 = zeros(5, u_len);
    wor3 = zeros(5,1);
    for k = 1:5             % as speech. Also 10 images make a realization of the user. So there are 5 
                            % realizations for each user.
        [P3(k,:) wor3(k)] = test(u, u_cont(u).name, EMalg, 'face', 10*(k-1)+1);
    end
    for i = 1:v_len
        for j = 1:s_len
            for k = 1:5         % for each user there are v_len*s_len*5 different realizations.
                                % For each realization the likelihoods of the modalities are saved
                                % as well as the world likelihoods and user specific informations.
                str1.u = u;
                str1.name = u_cont(u).name;
                str1.v = v_te(i);
                str1.s = s_te(j);
                str1.f = 10*(k-1)+1;
                str1.P = [P1(i,:) ; P2(j,:) ; P3(k,:)]; % this matrix has dimension 3x47.
                str1.wor = [wor1(i) ; wor2(j) ; wor3(k)]; % this matrix has dimension 3x1.
                LH = [LH ; str1];
            end
        end
    end
end

save(['likelihoods_' EMalg], 'LH');

