function train(UserNum, UserName, modality, EMalg)
% do the training for a specified user, a specified
% modality and a specified EM algorithm

%
% X: is the feature matrix, dimension of X: DxNoFeat

global userDir

switch modality
    case 'voice'
        global voiceDir;
        D = 20;            % the dimension of feature vector
        M = 8;             % the number of gaussian mixtures
        cont = dirRetrieval([voiceDir UserName '\*.wav'], 1); % read the speech files
        len = size(cont,1);
        X = [];
        load([userDir UserName '\voice\split']);  % which speech files are for training
        for i = 1:length(trnf)
            [y,fs,nbits] = wavread( [voiceDir UserName '\' cont(trnf(i)).name]);
            X = [X compute_mfcc(y, D)]; % get mfcc parameters
        end
    case 'face'
        global faceDir;
        global trainFaceFeat;
        D = 7;
        M = 2;
        load([faceDir trainFaceFeat]); % as voice. BUT the features are taken from a matrix 
        stat_users_features = stat_users_features(1:D, :, :);
        X = stat_users_features(:, :, UserNum);
        
%        plot(X);
%        pause;
    case 'signature'
        global signDir;
        D = 5;
        M = 4;
        cont = dirRetrieval([signDir UserName '\*.dat'], 1); % as voice
        len = size(cont,1);
        X = [];
        load([userDir UserName '\signature\split']);
        for i = 1:length(trnf)
            [y, gt] =  jonaspar([signDir UserName '\' cont(trnf(i)).name]);
            X = [X y];
        end
end

[X mv stdev]= normalize(X); % normalize the features and save global mean and std
mix = gmm(D, M, 'full');    % construct an empty gmm
mix.mean_value = mv;
mix.std_deviation = stdev;

switch EMalg
    case 'EM1'    % our EM
        [a,m,cm,lp]=EM(X, M, 50);
        fname = [drct 'gmm\EM1\' UserName '\' modality '\mix'];
        
        mix.priors = a;
        mix.centres = m';
        mix.covars = reshape(cm, [D,D,M]);
    case 'EM2'    % EM from net
        S = gmmb_create(X', ones(size(X,2),1), 'EM', 'components', M);%, 'verbose', 1);%, 'maxloops', 150);
        fname = [userDir UserName '\' modality '\mix'];

        mix.priors = S.weight';
        mix.centres = S.mu';
        mix.covars = S.sigma;
    case 'FJ'
        S = gmmb_create(X', ones(size(X,2),1), 'FJ', 'Cmax', 4*M);
        fname = [drct 'gmm\FJ\' UserName '\' modality '\mix'];

        mix.priors = S.weight';
        mix.centres = S.mu';
        mix.covars = S.sigma;
    case 'GEM'
        S = gmmb_create(X', ones(size(X,2),1), 'GEM', 'Cmax', 2*M);
        fname = [drct 'gmm\GEM\' UserName '\' modality '\mix'];

        mix.priors = S.weight';
        mix.centres = S.mu';
        mix.covars = S.sigma;
end
%plot(X(1,:),X(2,:),'.g',S.mu(1,:),S.mu(2,:),'k*');

save(fname, 'mix');
