function trainAll(modality, EMalg)
% it trains every user's GMM and the world GMM for each modality
% it calls two functions: train and trainWorld.

switch modality
    %%%%%%%%  VOICE   %%%%%%%%%
    case 'voice'
        global voiceDir;
        ucont = dirRetrieval(voiceDir, 0);
        ulen = size(ucont,1);

        for i = 1:ulen
            fprintf(1, 'Number and name of user (%d, %s)\n', i, ucont(i).name);
            if ucont(i).isdir == 1
                train(i, ucont(i).name, modality, EMalg);
            end
        end
        trainWorld(modality, EMalg);
    %%%%%%%%% FACE   %%%%%%%%%
    case 'face'
        global voiceDir;
        ucont = dirRetrieval(voiceDir, 0);
        ulen = size(ucont,1);

        for i = 1:ulen
            fprintf(1, 'Number and name of user (%d, %s)\n', i, ucont(i).name);
            if ucont(i).isdir == 1
                train(i, ucont(i).name, modality, EMalg);
            end
        end
        trainWorld(modality, EMalg);
    %%%%%%%%%  SIGNATURE  %%%%%%%%%
    case 'signature'
        global signDir;
        ucont = dirRetrieval(signDir, 0);
        ulen = size(ucont,1);

        for i = 1:ulen
            fprintf(1, 'Number and name of user (%d, %s)\n', i, ucont(i).name);
            if ucont(i).isdir == 1
                train(i, ucont(i).name, modality, EMalg);
            end
        end
        trainWorld(modality, EMalg);
end
