function trainWorld(modality, EMalg)
% do the training for a specified user, a specified
% modality and a specified EM algorithm
%
% X: is the feature matrix, dimension of X: DxNoFeat
%
%
% it is same with the function train. The difference is that the feature
% vectors are from all the users(not only one user).

global userDir;

switch modality
    case 'voice'
        global voiceDir;
        D = 20;            % the dimension of feature vector
        M = 24;             % the number of gaussian mixtures
        cont = dirRetrieval(userDir, 0);
        u_len = size(cont,1);
        X = [];
        for i = 1:u_len
            v_cont = dirRetrieval([voiceDir cont(i).name '\*.wav'], 1);
            load([userDir cont(i).name '\voice\split']);
            t_len = length(trnf);
            for j = 1:round(t_len/2)
                y = wavread( [voiceDir cont(i).name '\' v_cont(trnf(j)).name]);
                X = [X compute_mfcc(y, D)];
           end
        end
    case 'face'
        global faceDir;
        global trainFaceFeat;
        D = 7;
        M = 4;
        cont = dirRetrieval(userDir, 0);
        u_len = size(cont,1);
        load([faceDir trainFaceFeat]);
        stat_users_features = stat_users_features(1:D, :, :);
        [d1 d2 d3] = size(stat_users_features);
        X = reshape(stat_users_features, d1, d2*d3);
    case 'signature'
        global signDir;
        D = 5;
        M = 8;
        cont = dirRetrieval(userDir, 0);
        u_len = size(cont,1);
        X = [];
        for i = 1:u_len
            v_cont = dirRetrieval([signDir cont(i).name '\*.dat'], 1);
            load([userDir cont(i).name '\signature\split']);
            t_len = length(trnf);
            for j = 1:round(t_len/2)
                [y, gt] =  jonaspar([signDir cont(i).name '\' v_cont(trnf(j)).name]);
                X = [X y];
            end
        end
end

[X mv stdev]= normalize(X);
mix = gmm(D, M, 'full');
mix.mean_value = mv;
mix.std_deviation = stdev;

switch EMalg
    case 'EM1'    % our EM
        [a,m,cm,lp]=EM(X, M, 50);
        fname = [drct  'world\EM1\' modality '\mix'];
        
        mix.priors = a;
        mix.centres = m';
        mix.covars = reshape(cm, [D,D,M]);
    case 'EM2'    % EM from net
        S = gmmb_create(X', ones(size(X,2),1), 'EM', 'components', M);%, 'verbose', 1);
        global worldDir;
        fname = [worldDir modality '\mix'];

        mix.priors = S.weight';
        mix.centres = S.mu';
        mix.covars = S.sigma;
    case 'FJ'
        S = gmmb_create(X', ones(size(X,2),1), 'FJ', 'Cmax', 4*M);
        fname = [drct 'gmm\FJ\' UserName '\' modality '\mix'];

        mix.priors = S.weight';
        mix.centres = S.mu';
        mix.covars = S.sigma;
    case 'GEM'
        S = gmmb_create(X', ones(size(X,2),1), 'GEM', 'Cmax', 2*M);
        fname = [drct  'world\GEM\' modality '\mix'];

        mix.priors = S.weight';
        mix.centres = S.mu';
        mix.covars = S.sigma;
end

save(fname, 'mix');
