#!/usr/bin/perl 

## Version 0.1  Aug 2005 Hannes Pirker
##############################################
# trivial script for mapping phoneme-names from limsi to mbrola
$COMMENT = ";"; # comment char used by MBROLA
##############################################
$PROGNAME = "$0";
$VERSION  = "0.1";

$DOKU = "
$PROGNAME Version: $VERSION

USAGE: 
$PROGNAME LIMSI_MBROLA_file

If INPUT_FILE is missing, <STDIN> will be used.

DESCRIPTION 
trivial script for mapping phoneme-names from limsi to mbrola

Alternatively you could use mbrola-command-line-option
-R a~ A _ . 9~ I o~ O c O H h R r 2 x 9 X 

INPUT:
LimsiMbrola file

OUTPUT:
Mbrola .pho file 

OPTIONS

-h            print this message

Hannes Pirker July 2005
";

#### getting today's date ######## thanks to jm 
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
@monthnames=('JAN','FEB','MAR','APR','MAY','JUN',
             'JUL','AUG','SEP','OCT','NOV','DEC');
$month=$monthnames[$mon];
$today=sprintf("%02d-%s-%04d",$mday,$month,$year+1900);

@args = @ARGV;
use Getopt::Std;
getopts('h');

if ($opt_h) {die $DOKU};

print "$COMMENT$COMMENT Created from LIMSI-MBROLA-file by $PROGNAME @args (v $VERSION) ++ $today ++\n";

LINE: while (<>) 
  {
    if (m/^$COMMENT/) {
      print "$COMMENT$COMMENT$_";
      next LINE;
    }  
    ## perform mapping
    s/^A /a~ /;
    s/^\. /_ /;
    s/^I /9~ /;
    s/^O /o~ /;
    s/^c /O /;
    s/^h /H /;
    s/^r /R /;
    s/^x /2 /;
    s/^X /9 /;
    print;
  } ## end while

