#!/usr/bin/csh

# USAGE mary2Max.sh INFILE(S)
#       e.g. mary2Max.sh de*.txt

# INPUT:  text-files (de_*.txt, en_*.txt)
# OUTPUT: MaxMBROLA-files with one syllable per line.

# Make shure that INTYPE has the correct LANGUAGE 
set INTYPE = "TEXT_EN"; 
# set INTYPE = "TEXT_DE"; 

## adapt platform (windows, linux, mac) here
set PLATFORM = "-m"; 
# set PLATFORM = "-w"; 
# set PLATFORM = "-l"; 

foreach i ($*)
  set out = "$i:r"$PLATFORM.txt
  echo "Processing $i ... output will be: $out";
  maryclient.pl -i $INTYPE -o ACOUSTPARAMS $i >! $i:r.xml;
  mary2Max.pl $PLATFORM $i:r.xml >! $out
end
