#!/usr/local/bin/perl
#
# MARY Text-to-Speech System
# Minimal Socket client (for demonstration)
# Copyright (C) 2000-2002 DFKI GmbH
# Author: Marc Schroeder
#
# This is a minimal version of a socket client for the mary TtS system.
# It is intended to be used as a model for writing socket clients for
# particular applications. All input verification, command line options,
# and other luxury have been omitted.

use Getopt::Std;
getopts('hi:o:a:v:');
# use strict;
use IO::Socket;


############################
# Package-global variables #
############################
# global settings:
my $USAGE;
my $maryInfoSocket; # handle to socket server
my $maryDataSocket; # handle to socket server
my $host; # string containing host address
my $port;   # socket port on which we listen
my ($in, $out, $audiotype); # requested input / output format
my $voice; # default voice
my $id; # request ID



######################################################################
################################ main ################################
######################################################################

STDOUT->autoflush(1);

$host = "cling.dfki.uni-sb.de";
$port = 59125;
$in  = "TEXT_DE";
$out = "ACOUSTPARAMS";
# $out = "AUDIO";
# $audiotype = "MP3";
$audiotype = "WAVE";
$voice = "male";
# $voice = "de5";


# my $USAGE;
$USAGE = "
 Usage:
 $0 (-h) (-i INTYPE) (-o OTYPE) infile.txt > outfile.(xml|wav|mp3)
 Host is $host
 -h print htis message
 -i INTYPE (TEXT_DE, TEXT_EN, ...),        Default=$in 
 -o OUTTYPE (ACOUSTPARAMS, MBROLA, AUDIO), Default=$out
 -v voicefile (mbrola-voice),              Default=$voice
 -a audiotype of soundfile: WAVE or MP3,   Default=$audiotype; 

 Opens a socket to the Mary-Server at host $host and retrieves either 
 the results of the mary-TTS-component (ACOUSTPARAMS), Mbrola-files or 
even soundfiles

Author:
Original script by Marc Schroeder, DFKI
Command-line options and Help added by Hannnes Pirker, OFAI
";

if ($opt_h) {die $USAGE};
if ($opt_i) {$in=$opt_i};
if ($opt_o) {$out=$opt_o};
if ($opt_v) {$voice=$opt_v};
if ($opt_a) {$audiotype=$opt_a};

# create a tcp connection to the specified host and port
$maryInfoSocket = IO::Socket::INET->new(Proto     => "tcp",
                                        PeerAddr  => $host,
                                        PeerPort  => $port)
  or die "can't connect to port $port on $host: $!";

# avoid buffering when writing to server:
$maryInfoSocket->autoflush(1);              # so output gets there right away

########## Write input to server: ##########
# formulate the request:
print $maryInfoSocket "MARY IN=$in OUT=$out AUDIO=$audiotype";
if ($voice) { print $maryInfoSocket " VOICE=$voice"; }
print $maryInfoSocket "\015\012";

# receive a request ID:
$id = <$maryInfoSocket>;
chomp $id; chomp $id;

# open second socket for the data:
$maryDataSocket = IO::Socket::INET->new(Proto     => "tcp",
				PeerAddr  => $host,
				PeerPort  => $port)
    or die "can't connect to port $port on $host: $!";
# identify with request number:
print $maryDataSocket $id, "\015\012";

# copy standard input and/or files given on the command line to the socket
while (defined (my $line = <>)) {
    print $maryDataSocket $line;
}
# mark end-of-request:
print $maryDataSocket "\015\012"; # that is a \n, actually
shutdown($maryDataSocket, 1); # we have stopped writing data

########## Read output from server: ##########
# copy the data socket to standard output
if ($out ne "AUDIO") { # text output
    my $line;
    while (defined ($line = <$maryDataSocket>)) {
        print STDOUT $line;
    }
} else { # audio data output
    my $nr; # number of bytes read
    my $buf; # buffer to read into
    my $outnr; # number of bytes written
    while($nr = read($maryDataSocket, $buf, 100000)) {
	# (read returns no. of bytes read, 0 at eof)
        print STDOUT $buf
            or die "Write error on stdout";
    } # while read something from socket
} # audio output

### Read complaints from server:
my $line;
while (defined ($line = <$maryInfoSocket>)) {
    print STDERR $line;
}



