#!/usr/local/bin/perl 

## Version 0.1  Hannes Pirker
##############################################
## DEFAULT for F0 at START and END of sentence
$F0START = 100;
$F0DECREASE = 10;
$F0END   = $F0START - $F0DECREASE;
$COMMENT = ";"; # comment char used by MBROLA
##############################################

$PROGNAME = "$0";
$VERSION  = "0.1";

$DOKU = "
$PROGNAME Version: $VERSION

USAGE: 
$PROGNAME (-h) (-o) (-f) (-s f0_at_Start) (-s f0_at_End) (-t) MBROLA_pho_file

If INPUT_FILE is missing, <STDIN> will be used.

DESCRIPTION 

Simple reformatting of mbrola-files for making make them usable in MaxMBROLA

INPUT:
Mbrola .pho file

OUTPUT:
Mbrola file with f0 removed and/or printed as a single line

OPTIONS

-h            print this message
-f(0preserve) preserve f0, the default is to omit f0
-o(neline)    collapse resulting mbrola into one line for being used 
              in MaxMBROLA
-s(tartf0)    specify the f0 at the begining of sentence, DEFAULT=$F0START 
-e(ndf0)      specify the f0 at the end      of sentence, DEFAULT=(startf0 - $F0DECREASE)  
-t(race)

Hannes Pirker July 2005
";

#### getting today's date ######## thanks to jm 
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
@monthnames=('JAN','FEB','MAR','APR','MAY','JUN',
             'JUL','AUG','SEP','OCT','NOV','DEC');
$month=$monthnames[$mon];
$today=sprintf("%02d-%s-%04d",$mday,$month,$year+1900);

@args = @ARGV;
use Getopt::Std;
getopts('htofs:e:');

if ($opt_h) {die $DOKU};
if ($opt_s) {$F0START=$opt_s; $F0END=$F0START-$F0DECREASE};
if ($opt_e) {$F0END=$opt_e};

# initialize
$first = 'on';
$f0old = "";
$del   = "";
$end   = "";

if (! $opt_o) {
 print "$COMMENT$COMMENT Created from MBROLA-file by $PROGNAME @args (v $VERSION) ++ $today ++\n";
}

LINE: while (<>) 
  {
    if (m/^$COMMENT/) {
      if (!$opt_o) {print "$COMMENT$COMMENT$_"};
      next LINE;
    }  
    chomp; 
    ($ph,$dur,@f0) = split;
    if ($dur) {$dur = round_to_int($dur)}
    else {next LINE}; # remove empty lines
    if ($f0old) {print " $f0old"};
    print "$end"; # either a newline or ""
    print "$del$ph $dur";
    if ($opt_f) {
      $f0old = "@f0";
      $f0old =~ s/[(\)]//g;  
      $f0old =~ s/,/ /g;  # "(x,y)" -> "x y"  
     }
    else {$f0old = ""};
    # at FIRST record set del end end
    if ($first) {
      $first=0;
      if (!$opt_f) {$f0old = "5 $F0START";};
      if ($opt_o) {$del=" * "}
      else  {$end="\n"}
    }
  } ## end while

### at end of file
### if necessary print f0 for flat-f0
if (!$opt_f) {$f0old = "95 $F0END"}
print " $f0old$end";
if ($opt_o) {
  print "$del\_ 100 $f0old"; # due to a bug in MaxMBROL extra final pause 
  print " #\n";
}

# ----------------------------------------------
# rounding to integer
sub round_to_int{
  local ($in) = @_;
  local ($intin) = int($in);
  
  if (($in - $intin) < 0.5){return $intin} 
  else {return $intin++}
}
# ----------------------------------------------
