// Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop)
// D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, M. Dimiccoli, M. Mancas, S. Raidt, J.E. Viallet, E. Yagci.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//
// Users shall give appropriate references to the eNTERFACE'05 Website
// (www.enterface.net) in scholarly literature for which this software is used or mentioned.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//----------------------------------------------------------------
//---        Speech and Gesture Fusion Application              --
//----------------------------------------------------------------
//
// Enterface summer workshop 2005
// Project 7
//
//----------------------------------------------------------------
// Olivier Bernier - 11 August 2005
// France Tlcom R&D
// 2 av Pierre Marzin
// 22307 Lannion Cedex
// FRANCE
// email: olivier.bernier@rd.francetelecom.com
//----------------------------------------------------------------

#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <errno.h>

// Renvoie le numero de connexion (a utiliser pour les autres fonctions).
// L'addresse est le numero IP du serveur.
// Le port est le port sur lequel le seveur attend les connexions
int Connecter( const char* addresse_ip_serveur, int port )
{
	struct sockaddr_in addresse_serveur;
	int sock;

	if( ( sock = socket( AF_INET, SOCK_STREAM, 0 ) ) == -1 )
	{
		fprintf( stderr, "Erreur d'ouverture de socket\n" );
		return( -1 );
	}

	// adresse serveur

	addresse_serveur.sin_family = AF_INET;
	addresse_serveur.sin_port = htons( port );

	if( inet_aton( addresse_ip_serveur, &(addresse_serveur.sin_addr) ) == 0 )
	{
		fprintf( stderr, "Erreur d'addresse IP de serveur\n" );
		close( sock );
		return( -1 );
	} 

	if( connect( sock, (struct sockaddr*) &addresse_serveur, sizeof( addresse_serveur ) ) == -1 )
	{
		fprintf( stderr, "Erreur de connexion socket\n" );
		close( sock );
		return( -1 );
	}

	return( sock );
}


// Envoi de donnees.
void Envoyer( int connexion, const void* p_msg, size_t taille )
{
	if( write( connexion, p_msg, taille ) != taille )
	{
		fprintf( stderr, "Erreur: envoi invalide ou incomplet pour socket\n" );
	}
}

// Deconnexion.
void Deconnecter( int connexion )
{
	if( shutdown( connexion, SHUT_RDWR ) == -1 )
	{
		fprintf( stderr, "Erreur de shutdown de socket\n" );
		fprintf( stderr, "Errno = %d\n", errno ); 
	}

	if( close( connexion ) == -1 )
	{
		fprintf( stderr, "Erreur de fermeture de socket\n" );
		fprintf( stderr, "Errno = %d\n", errno ); 
	}
}
