// Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop)
// D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, M. Dimiccoli, M. Mancas, S. Raidt, J.E. Viallet, E. Yagci.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//
// Users shall give appropriate references to the eNTERFACE'05 Website
// (www.enterface.net) in scholarly literature for which this software is used or mentioned.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//----------------------------------------------------------------
//---        Speech and Gesture Fusion Application              --
//----------------------------------------------------------------
//
// Enterface summer workshop 2005
// Project 7
//
//----------------------------------------------------------------
// Sbastien Carbini - 11 August 2005
// France Tlcom R&D
// 2 av Pierre Marzin
// 22307 Lannion Cedex
// FRANCE
// email: sebastien.carbini@rd.francetelecom.com
//----------------------------------------------------------------


// Includes
//----------------------------------------------------------------
extern "C"
{
#include "Socket.h"
}

#include <string.h>
#include <stdlib.h>
#include <math.h>

// Global variables
//----------------------------------------------------------------
char ADRESSE_IP1[255] ;   // Ip adress of the 3D application computer
int PORT1;                // Port to use with the 3D application computer
char ADRESSE_IP2[255] ;
int PORT2;

int OUT_SOCKET1;          // Socket return once connected
int OUT_SOCKET2;

bool PenDown;

bool premiere_solution_rejet = false;

// Char contenant le rsultat de la reco de parole
char reco_parole[1024];
bool mot_reconnu = false;

// Functions
//----------------------------------------------------------------
// Libere la memoire et quitte le programme
void	LibererMemoire()
{
	printf("[Disconnect from server %s: ", ADRESSE_IP1);

	Deconnecter( OUT_SOCKET1 );
	Deconnecter( OUT_SOCKET2 );

	printf("OK]\n[Libere la memoire partagee: ");

	char command[ 20000 ];
	sprintf( command, "./clean_ipcm");
	system( command );

	printf("Ok]\n");
}

// Boucle principale
void Acquerir()
{	
	int tps1, x,y;
	char s[1024];
	char s_old[1024];
	char out_c[1024];


	strcpy(s,"");
	strcpy(out_c,"");
	strcpy(reco_parole,"");
	mot_reconnu = false;

	// connection ip
	strcpy(ADRESSE_IP1,"10.104.11.36");//36");
	PORT1=40000;

 	strcpy(ADRESSE_IP2,"10.104.11.34");//36");
 	PORT2=40000;
	
	printf("[Connection to 3D objects tool (ip: %s , port: %d)...", ADRESSE_IP1, PORT1); fflush(stdout);
	OUT_SOCKET1 = Connecter( ADRESSE_IP1, PORT1);
	
	if ( OUT_SOCKET1 != -1)
	{
		printf("OK]\n"); fflush(stdout);
	}

	printf("[Connection to 3D clone (ip: %s , port: %d)...", ADRESSE_IP2, PORT2); fflush(stdout);
	OUT_SOCKET2 = Connecter( ADRESSE_IP2, PORT2);
	if ( OUT_SOCKET2 != -1)
	{
		printf("OK]\n"); fflush(stdout);
	}

	// Boucle principale d'acquisition
	printf("[Dbut acquisition..."); fflush(stdout);
	while(true)
	{
		strcpy(s_old, s);

		fscanf(stdin, "%s", s);
		
		if ((!*s)||feof(stdin)) 
			exit(0);

		if (strncmp(s, "Head", 4)==0)		// evenement video
		{
			int iii;
			for( iii=0; iii<200; iii++)
			{
				out_c[iii] = '0';
			}

			if (mot_reconnu)
			{
				sprintf(out_c,"%s,speech,%s;", s, reco_parole );
				printf("[%s]\n", out_c); fflush(stdout);
			}
			else
			{
				sprintf(out_c,"%s,speech,0;", s, reco_parole );
			}

//			printf("<%d data sent>\n", strlen( out_c ) );

			if ( OUT_SOCKET1 != -1)
			Envoyer( OUT_SOCKET1, (const void*) out_c, 200 );

			if ( OUT_SOCKET2 != -1)
				Envoyer( OUT_SOCKET2, (const void*) out_c, 200 );
			
			strcpy(reco_parole, "");
			mot_reconnu = false;
		}
		else if ( (strncmp(s,"Sol=1",5)==0) || ( (premiere_solution_rejet) &&  (strncmp(s,"Sol=2",5)==0) ) )// evenement audio
		{
			char debug[255];
			
			strcpy(debug, s);
			strcat(debug,"-");

			fscanf(stdin, "%s", s); // ;
			fscanf(stdin, "%s", s); // Dec="mot"
	
			mot_reconnu = true;
			premiere_solution_rejet = false;

			if (strncmp( s, "Dec=\"pose",9 ) == 0)
				strcpy( reco_parole, "1" ); //move
			else if (strcmp( s, "Dec=\"lche\"" ) == 0)
				strcpy( reco_parole, "2" );//OK
			else if (strncmp( s, "Dec=\"slectionne",16 ) == 0)
				strcpy( reco_parole, "3" );//select
			else if (strcmp( s, "Dec=\"balou\"" ) == 0)
				strcpy( reco_parole, "4" );//rotate
			else if (strcmp( s, "Dec=\"chercanne\"" ) == 0)
				strcpy( reco_parole, "5" );//scale
//			else if (strcmp( s, "Dec=\"chec\"" ) == 0)
//				strcpy( reco_parole, "6" );//search
//			else if (strcmp( s, "Dec=\"click\"" ) == 0)
//				strcpy( reco_parole, "7" );//select_group
//			else if (strcmp( s, "Dec=\"prend" ) == 0)//dire "prend la reine"
//				strcpy( reco_parole, "8" );//select_next (during group search)
//			else if (strcmp( s, "Dec=\"tour" ) == 0)//dire "tour prend"
//				strcpy( reco_parole, "9" );//end_select_group
			else if (strcmp( s, "Dec=\"cavalier" ) == 0)
				strcpy( reco_parole, "10" );//retrieve
//			else if (strcmp( s, "Dec=\"pose\"" ) == 0)
//				strcpy( reco_parole, "11" );//save geometry
			else if (strcmp( s, "Dec=\"met" ) == 0)
			{
				fscanf(stdin, "%s", s); // ;
				if (strcmp( s, "la" ) == 0)
				{
					fscanf(stdin, "%s", s); // ;
					if ( strncmp(s, "tour", 4) == 0)
						strcpy( reco_parole, "13" );// clone 
					else
						mot_reconnu = false;
				}
				else if (strcmp( s, "le" ) == 0)
				{
					fscanf(stdin, "%s", s); // ;
					if ( strncmp(s, "roi", 3) == 0)
						strcpy( reco_parole, "12" );// delete object
					else
						mot_reconnu = false;
				}
				else
					mot_reconnu = false;
			}
			else if (strcmp( s, "Dec=\"O.K." ) == 0) // O.K. la
			{
				fscanf(stdin, "%s", s); // ;
				if ( strncmp(s, "l", 2) == 0)
					strcpy( reco_parole, "14" );//start sketching
				else
					mot_reconnu = false;
			}
			else if (strcmp( s, "Dec=\"REJET\"")==0)
			{
				mot_reconnu = false;
				premiere_solution_rejet = true;
			}
			else
				mot_reconnu = false;

			if (mot_reconnu)
			{		
				strcat(debug, s);
				printf(debug);
				fflush(stdout);
			}
		}
		else if ( (strncmp(s,"Acquisition_arretee",7)==0) )
		{
			LibererMemoire();

			printf("------------------------------------------------------------\n");
			printf("--- Fin du Controle de la souris\n");
			printf("------------------------------------------------------------\n");
			fflush(stdout);

			exit(0);
		}
	}	
}

/****************************************************************/
/* MAIN                                                         */
/****************************************************************/
int main(int argc, char **argv)
{
	printf("--------------------------------------------------------------\n");
	printf("--- Enterface 2005 - Speech and Gesture Fusion Application ---\n");
	printf("--------------------------------------------------------------\n");
	printf("[Libere la memoire partagee:\n");
	char command[ 20000 ];
	sprintf( command, "./clean_ipcm");
	system( command );
	printf(" Ok]\n");
	fflush(stdout);
	
	PenDown = false;
	
	Acquerir();

	return 1;
}

