/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members:
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.            

Author: M. Dimiccoli      e-mail: mariella@gps.tsc.upc.es
*/


/*
*   DeformMesh: public class
*
*   Input:   controlPoint[]  coordinates of the control point
*            distance[]      translation in each direction (x, y, z)
*			 connections     number of level of connections to the control point
*	Output: 
*
*
*	
*
*
*/



#include "CDeformation.h"
#include <cmath>
#include <vector>

#include <iostream>
using namespace std;

void StaticObject::DeformMesh(float controlPoint[3], float distance[3], int connections)
{
	float multiplier;
	float sigma=5;	//deviation of the distribution
	//remove this line, debugging and testing
	controlPoint[0] = VertexPos[0][0];controlPoint[1] = VertexPos[0][1];controlPoint[2] = VertexPos[0][2];

	FindGeoPoints(controlPoint, 3);

	for(int i=0; i<GeoNumbers;i++)
	{

			multiplier = exp( -0.5*pow(sigma,-2)*
				( pow(VertexPos[GeoPoints[i]][0] - controlPoint[0], 2) + pow(VertexPos[GeoPoints[i]][1] - controlPoint[1], 2) + 
					pow(VertexPos[GeoPoints[i]][2] - controlPoint[2], 2) ) );

			VertexPos[GeoPoints[i]][0] += distance[0]*multiplier;
			VertexPos[GeoPoints[i]][1] += distance[1]*multiplier;
			VertexPos[GeoPoints[i]][2] += distance[2]*multiplier;

			cout << multiplier << endl;

	}

}

/*
*   FindGeoPoints: private class
*
*   Input:   controlPoint[]  coordinates of the control point
*			 connections     number of level of connections to the control point
*	Output: 
*
*
*   Return a list of points connected to the control point 
*
*
*/


void StaticObject::FindGeoPoints(float controlPoint[3], int connections)
{
	int index; 

	//find the index of the control point
	for(int i=0; i<NumOfVertices; i++)
		if(	controlPoint[0] == VertexPos[i][0] && controlPoint[1] == VertexPos[i][1] && 
			controlPoint[2] == VertexPos[i][2] )
			index = i;

	//initialization of the search parameters
	bool inList = false;
	int begin=0, conNumber=0, end=0;
	vector<int> conPoints;
	conPoints.push_back(index);

	while (conNumber < connections )
	{	
		begin = end;
		end = conPoints.size();
		for(int i=begin; i<end; i++)	//search the list for the connected points
			for(int j=0; j<NumOfTriangles; j++)	//search the triangles for the points in the list
				if(MeshFaces[3*j] == conPoints[i] || MeshFaces[3*j +1] == conPoints[i] ||MeshFaces[3*j +2] == conPoints[i])
				{
					cout << " I am here" << endl;
					//add to the conPoints if the point is connected to the searched one
					for(int k=0; k<3; k++)	//for the points in the triangle
					{
						inList = false;	//check if it is in the list
						for(int l=0; l< conPoints.size(); l++)	//check the conPoints
							if(conPoints[l] == MeshFaces[3*j +k] )
								inList = true;
                        
						if(!inList)
							conPoints.push_back(MeshFaces[3*j +k]);
					}
				}
		
		conNumber++;
	}

	GeoPoints = (size_t *) malloc(sizeof(size_t)*conPoints.size() );

	

	for(int i=0; i< conPoints.size(); i++)
		GeoPoints[i] = conPoints[i];
	
	GeoNumbers = conPoints.size();


}

