/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members:
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.            

Author: M. Dimiccoli      e-mail: mariella@gps.tsc.upc.es
*/


#include "stdafx"
#include <stdio.h>
#include <malloc.h>

#include <iostream>
#include <fstream>
#include <math.h>
#include <vector>

#include "2d_resampling.h"


void FilterCurves(double *picX, double *picY, int count)
{ 
  float dmean,Ta,Tb,x,y,d,d1,d2,Dgeo;
  int n=3,i,j,a,app;
  int good_closed=0,open_shape=0,one_out=0,two_out=0;//flags


/* Determining statistical thresholds Ta and Tb  */
/*************************************************/
dmean=0;//mean distance between two consecutive points
for(i=0;i<count-1;i++)
{
	x=picX[i]-picY[i+1];
    y=picY[i]-picY[i+1];
    dmean=dmean+sqrt(x*x+y*y);    
}
dmean=dmean/(count-1);
Ta=dmean*3;
Tb=(n+2)*dmean;

/*************************************************/
/*  Resampling  */
i= 0;
app = count-n-1;
while (i<app)
{
Dgeo=0;
//geodesic path between the latest n+2 points
    for (j=i;j<=i+n;j++)//prova con n-1
     {
		x=picX[j]-picX[j+1];
        y=picY[j]-picY[j+1];
        d=sqrt(x*x+y*y);    
        Dgeo=Dgeo+d;
	}
	if(Dgeo<Tb )//delete n points
	{//delete the points between point i and point i+n
		for(j=i+1;j<=count-n-1;j++)
		{
		 picX[j]= picX[j+n];
		 picY[j]=picY[j+n];
		}//end for
	count=count-n;
	}//end if
    app=count-n-1;
    i=i+1;
}
/*********************************************************************/

/* Deleting initial and final points */

a= (int) (0.3* count);

//check for the first case: good closed 
//distance between the first and the last point is smaller than dmean
    x=picX[count-1]-picX[0];
    y=picY[count-1]-picY[0];
    d=sqrt(x*x+y*y);
    if(d<dmean)
	{
        good_closed=1;
        picX[count]=picX[0];//closing the curve
        picY[count]=picY[0];
        count++;
    }
////////////////////////////////////////
    
   
//check for the first case: open shape
//distance between the first and the last point is bigger than (n+2)*dmean
    x=picX[count-1]-picX[0];
    y=picY[count-1]-picY[0];
    d=sqrt(x*x+y*y);
    if(d>(5*dmean))
       {
		open_shape=1;
		picX[count-1]=picX[0];//closing the curve
        picY[count-1]=picY[0];
        count++;
		}//end if
    
//check for the second case: one segment out the shape
if(open_shape==0 && good_closed==0)
  {  
	

for (i=0;i<=a;i++)
	{
        x=picX[count-i-1]-picX[i];
        y=picY[count-i-1]-picY[i];
        d1=sqrt(x*x+y*y);   
        x=picX[count-i-2]-picX[i];
        y=picY[count-i-2]-picY[i];
        d2=sqrt(x*x+y*y);//distance between 
		if ((d1-d2)>Ta)
			{
            one_out=1;
            for (i=0;i<=a;i++)
              	{  
				x=picX[count-1]-picX[i];
                y=picY[count-1]-picY[i];
                d=sqrt(x*x+y*y);
                if(d>Ta)
				{  for(j=i;j<count-i;j++)
					{
					picX[j]=picX[count+i];
					picY[j]=picY[count+i];
					}//end for
				    count--;
                }//end if
            }//end for
        }//end if 
    }//end for
}//end if
//check for the third case: two segments out the shape
if(open_shape==0 &&  good_closed==0 && one_out==0)
   { two_out=1;
    for (i=0;i<=a;i++)
		{
			x=picX[count-1]-picX[i];
			y=picY[count-1]-picY[i];
			d=sqrt(x*x+y*y);
			if(d>Ta)
			{  for(j=i;j<=count-i;j++)
					{
					picX[j]=picX[count+i];
					picY[j]=picY[count+i];
					}//end for
				count--;
			}//end if
		}//end for
    for(i=0;i<=a;i++)
		{
			x=picX[count+1-i]-picX[0];
			y=picY[count+1-i]-picY[0];
			d1=sqrt(x*x+y*y);
			x=picX[count-i]-picX[0];
			y=picY[count-i]-picY[0];
			d2=sqrt(x*x+y*y);
			if(d1>d2)
			{
				for(j=i;j=count-i;j++)
					{
					picX[j]=picX[count+i];
					picY[j]=picY[count+i];
					}//end for
				    count--;
			}//end if
		}//end for
	picX[count-1]=picX[0];
	picY[count-1]=picY[0];
	count++;
	}//end if


}//end function