/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

Author: M. Dimiccoli      e-mail: mariella@gps.tsc.upc.es

*/
#include "stdafx.h"
#include <stdio.h>
#include <cmath>
#include <vector>

#include <fstream>
#include <iostream>
using namespace std;

#include "CAddVer.h"

void StaticObject::MyAddVer(int mini)
{
	float max_area=0, area,dot_product,sin_A,cos;
	float AB[3],AC[3], mod_AB, mod_AC, mod_CH,CB[3],mod_CB; 
	int	ind,index;

	while(NumOfTriangles < mini)
	{
		for(int j=0; j<NumOfTriangles; j++)	//search the triangle with the bigger area 
			{
				for(int k=0;k<3;k++)
				{	
					AB[k] =  VertexPos[MeshFaces[(3*j)]][k] - VertexPos[MeshFaces[(3*j)+1]][k];
					AC[k] =  VertexPos[MeshFaces[(3*j)]][k] - VertexPos[MeshFaces[(3*j)+2]][k];
				}
		
				mod_AB = sqrt(pow(AB[0],2)+ pow(AB[1],2) + pow(AB[2],2));
				mod_AC = sqrt(pow(AC[0],2)+ pow(AC[1],2) + pow(AC[2],2));
				dot_product = 0;
				for(k=0;k<3;k++)
				{
					dot_product += AB[k] * AC[k];
				}
				sin_A = sqrt(1- dot_product/(mod_AB * mod_AC) );
				mod_CH = sin_A * mod_AC;
				area = (mod_CH * mod_AB)/2;
				if (max_area < area) 
				{
				max_area = area;
				ind = j;//index of bigger triangle
				}
		}//end for

		//check if the bigger triangle have a corner > 90
		for(int k=0;k<3;k++)
			{	 
				AB[k] =  VertexPos[MeshFaces[3*ind]][k] - VertexPos[MeshFaces[3*ind + 1]][k];
				AC[k] =  VertexPos[MeshFaces[3*ind]][k] - VertexPos[MeshFaces[3*ind + 2]][k];
				CB[k] =  VertexPos[MeshFaces[3*ind +2]][k] - VertexPos[MeshFaces[3*ind +1]][k];
			}

		mod_AB = sqrt(pow(AB[0],2)+ pow(AB[1],2) + pow(AB[2],2));
		mod_AC = sqrt(pow(AC[0],2)+ pow(AC[1],2) + pow(AC[2],2));
		mod_CB = sqrt(pow(CB[0],2)+ pow(CB[1],2) + pow(CB[2],2));
		dot_product = 0;
			for(k=0;k<3;k++)
			{
				dot_product += AB[k] * CB[k];
			}
			//cos_B
			cos =  dot_product/(mod_AB * mod_CB);


		if(cos > 0)
		{   AC[0] = MeshFaces[3*ind];//A
		    AC[1] = MeshFaces[3*ind+2];//C
			//add new vertex in the middle of AC
			VertexPos[NumOfVertices] = (float *) malloc(sizeof(float)*3);
			for(int k=0;k<3;k++)
				{
				VertexPos[NumOfVertices][k]	 =  (VertexPos[MeshFaces[3*ind]][k] + VertexPos[MeshFaces[3*ind+2]][k])/2;
				}
			NumOfVertices++;
			//delete old triangle and add news triangles BCM and AMB

			//ABM
			for(k=0;k<2;k++)
					{
						MeshFaces[(3*NumOfTriangles)+k] = MeshFaces[3*ind +k];
					}
			MeshFaces[(3*NumOfTriangles)+2] = NumOfVertices-1;
			NumOfTriangles++;

			//BCM
			
			MeshFaces[(3*ind)] = NumOfVertices-1;

			//look for a triangle which have a commun AC side
			for(j=0; j<NumOfTriangles; j++)
			{  
				for(k=0;k<3;k++)
				{
					if( MeshFaces[(3*j) +k ] == AC[0]) 
					{	
						for(int m=0;m<3;m++)
						{
							if(MeshFaces[(3*j) +m ] == AC[1])//vertex C
							{							
								index = j;//index of the triangle 
								for(int n=0;n<3;n++)
								{
									if(MeshFaces[(3*j) +n ] != AC[0] && MeshFaces[(3*j) +n ] != AC[1])
										AC[2] = MeshFaces[(3*j) +n ];//P
								}//end for

							}//end if
						}//end for
					}//end if	

				}//end for			
		
			}//end for
			//delete old triangle and add news triangles APM and PMC
			MeshFaces[(3*NumOfTriangles)] = AC[0];//A
			MeshFaces[(3*NumOfTriangles) +1] = NumOfVertices-1;//M
			MeshFaces[(3*NumOfTriangles) +2] = AC[2];//P
			NumOfTriangles++;

			//PMC
			MeshFaces[(3*index)] = NumOfVertices-1;//M
			MeshFaces[(3*index) +1] =  AC[2];//P
			MeshFaces[(3*index) +2] =  AC[1];//C




		}//end if
		else
		{	
			dot_product = 0;
			for(k=0;k<3;k++)
			{
				dot_product += AC[k] * CB[k];
			}
			//cos_C
			cos = dot_product/(mod_AC * mod_CB);
			if(cos > 0)
			{	AB[0] = MeshFaces[3*ind];//A
				AB[1] = MeshFaces[3*ind+1];//B
				//add new vertex in the middle of AB
				VertexPos[NumOfVertices] = (float *) malloc(sizeof(float)*3);
				for(int k=0;k<3;k++)
				{	
				VertexPos[NumOfVertices][k]	 =  (VertexPos[MeshFaces[(3*ind)]][k] + VertexPos[MeshFaces[3*ind+1]][k])/2;
				
				}
				NumOfVertices++;
				//delete old triangle and add news triangles BCM
				
				//ACM
				MeshFaces[(3*NumOfTriangles)] = MeshFaces[3*ind];//A
				MeshFaces[(3*NumOfTriangles)+1] = MeshFaces[3*ind+2];//B
				MeshFaces[(3*NumOfTriangles)+2] = NumOfVertices-1;//M
				NumOfTriangles++;
				//BCM
			
				MeshFaces[(3*ind)] = NumOfVertices-1;//M
				//look for a triangle which have a commun AB side
				for(j=0; j<NumOfTriangles; j++)
				{  
					for(k=0;k<3;k++)
					{
						if( MeshFaces[(3*j) +k ] == AB[0])//A 
						{	
						for(int m=0;m<3;m++)
							{
								if(MeshFaces[(3*j) +m ] == AB[1])//B
								{							
									index = j;//index of the triangle 
									for(int n=0;n<3;n++)
									{
										if(MeshFaces[(3*j) +n ] != AB[0] && MeshFaces[(3*j) +n ] != AB[1])
										AB[2] = MeshFaces[(3*j) +n ];//P
									}//end for

								}//end if
							}//end for
						}//end if
					}//end for			
		
				}//end for
			
			//delete old triangle and add news triangles APM and PMB
			MeshFaces[(3*NumOfTriangles)] = AB[0];//A
			MeshFaces[(3*NumOfTriangles) +1] = NumOfVertices-1;//M
			MeshFaces[(3*NumOfTriangles) +2] = AB[2];//P
			NumOfTriangles++;
			//PMB
			MeshFaces[(3*index)] = NumOfVertices-1;//M
			MeshFaces[(3*index) +1] =  AB[1];//B
			MeshFaces[(3*index) +2] =  AB[2];//P



			}//end if
			else
			{
				dot_product = 0;
				for(k=0;k<3;k++)
				{
				dot_product += AC[k] * AB[k];
				}
				//cos_A
				cos = dot_product/(mod_AC * mod_AB);
				if(cos > 0)
				{
					CB[0] = MeshFaces[3*ind + 2];//C
				    CB[1] = MeshFaces[3*ind+1];//B
				 	//add new vertex in the middle of CB
					VertexPos[NumOfVertices] = (float *) malloc(sizeof(float)*3);
					for(int k=0;k<3;k++)
					{	
					VertexPos[NumOfVertices][k]	 =  (VertexPos[MeshFaces[(3*ind + 1)]][k] + VertexPos[MeshFaces[3*ind+2]][k])/2;
					
					}
					NumOfVertices++;
					//delete old triangle and add news triangles AMC and AMB

					//ACM
					MeshFaces[(3*NumOfTriangles)] = MeshFaces[3*ind];//A
					MeshFaces[(3*NumOfTriangles)+1] = MeshFaces[3*ind+2];//C
					MeshFaces[(3*NumOfTriangles)+2] = NumOfVertices-1;//M
					NumOfTriangles++;
					//AMC
					MeshFaces[(3*ind) +1 ] = NumOfVertices-1;

					//look for a triangle which have a commun CB side
					for(j=0; j<NumOfTriangles; j++)
					{  
						for(k=0;k<3;k++)
						{
						if( MeshFaces[(3*j) +k ] == CB[0])//C 
							{	
							for(int m=0;m<3;m++)
							{
								if(MeshFaces[(3*j) +m ] == CB[1])//B
								{							
								index = j;//index of the triangle 
								for(int n=0;n<3;n++)
									{
									if(MeshFaces[(3*j) +n ] != CB[0] && MeshFaces[(3*j) +n ] != CB[1])
										CB[2] = MeshFaces[(3*j) +n ];//P
									}//end for

								}//end if
							}//end for
							}//end if

						}//end for			
		
					}//end for
			
				//delete old triangle and add news triangles CPM and PMB
			MeshFaces[(3*NumOfTriangles)] = CB[0];//C
			MeshFaces[(3*NumOfTriangles) +1] = NumOfVertices-1;//M
			MeshFaces[(3*NumOfTriangles) +2] = CB[2];//P
			NumOfTriangles++;
			//PMB
			MeshFaces[(3*index)] = NumOfVertices-1;//M
			MeshFaces[(3*index) +1] =  CB[1];//B
			MeshFaces[(3*index) +2] =  CB[2];//P







				}//end if
				else
				{
					/***************************************************************************************/
					/************************ Add two new triangles ****************************************/
					//add new vertex in the centre of masse
					VertexPos[NumOfVertices] = (float *) malloc(sizeof(float)*3);
					for(int k=0;k<3;k++)
					{//centre of masse	
					VertexPos[NumOfVertices][k]	 =  (VertexPos[MeshFaces[(3*ind)]][k] + VertexPos[MeshFaces[3*ind+1]][k] + VertexPos[MeshFaces[3*(ind+2)+k]][k])/3;
					}
					NumOfVertices++;
					//delete old triangle and add news triangles ABM BCM ACM
			
					for(k=0;k<2;k++)
					{
					MeshFaces[(3*NumOfTriangles)+k] = MeshFaces[(3*ind)+k];//A, B
					}
					MeshFaces[(3*NumOfTriangles)+2] = NumOfVertices-1;//M
					NumOfTriangles++;

					for(k=1;k<3;k++)
					{
					MeshFaces[(3*NumOfTriangles)+k] = MeshFaces[(3*ind)+k];//B, C
					}
					MeshFaces[(3*NumOfTriangles)] = NumOfVertices-1;//M
					NumOfTriangles++;
					//ACM
					MeshFaces[(3*ind)+1] = NumOfVertices-1;//M 
				}//third else
			}//second else
		}//first else  

	}//end while
}		













