/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// The implementation of the functions defined in "FilterPoints.cpp"

#include "LM_FilterPoints.h"
#include "LM_HelperFunctions.h"
#include <vector>
#include <cmath>

using std::vector;

// Make Distances between the points uniform
void UniformResample( double **data, int &dataSize)
{
	//Find the minimum distance between two points in the data
	double *distance = new double[dataSize];
	double minvalue, maxvalue;
	int index, i;
	for(i=0; i<dataSize-1; i++)
		distance[i] = sqrt( pow( (*data)[2*i] - (*data)[2*i+2],2) + pow((*data)[2*i+1] - (*data)[2*i+3],2) );
	Vmin(distance,dataSize-1, minvalue, index);
	Vmax(distance,dataSize-1, maxvalue, index);

	//adjust interpolation
	if( minvalue > maxvalue/8.0 )
		minvalue = minvalue/6.5;

	// Avoid division by zero
	if(minvalue <= 0.1)
		minvalue = 0.1;

	vector<double> newpoints;
	newpoints.resize(0);
	double ratio;
	//Interpolate newpoints
	for(i=0; i<dataSize-1; i++)
	{
		ratio = distance[i]/minvalue;
		for(int j=0; j<(int)floor(ratio);j++)
		{
			newpoints.push_back( (*data)[2*i] + (double)j/ratio*((*data)[2*i+2] - (*data)[2*i])  );
			newpoints.push_back( (*data)[2*i+1] + (double)j/ratio*((*data)[2*i+3] - (*data)[2*i+1]) );
		}
	}
	// Add the last tow points
	newpoints.push_back((*data)[2*dataSize -2] );
	newpoints.push_back((*data)[2*dataSize -1] );


	//Reduce the Number of Points
	delete (*data);
	(*data) = new double[2*NUMPOINTS];

	for(i=0; i<NUMPOINTS; i++)
	{
		(*data)[2*i] = newpoints[ 2*(int)floor( (double)i*newpoints.size()/(double)NUMPOINTS/2.0)];
		(*data)[2*i+1] = newpoints[ 2*(int)floor( (double)i*newpoints.size()/(double)NUMPOINTS/2.0) +1 ];
	}

	// Write the number of points
	dataSize = NUMPOINTS;

	// Delete variables
	delete distance;

}
		