/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// The implementation of the functions defined in "HelperFunction.h"

#include "LM_HelperFunctions.h"

double V2norm( double vect[2] )
{
	double norm = sqrt( pow(vect[0],2) + pow(vect[1],2) );

	if(norm ==0)
		return 1E-10;
	else
		return norm;

}

double Vdot(double vect1[2], double vect2[2])
{
	return vect1[0]*vect2[0] + vect1[1]*vect2[1];
}

//Find the minimum number in a vector and return its value and index
void Vmin( double *vect, const int size, double &value, int &index )
{

	value = 1E20;
	for(int i=0; i<size; i++)
		//May pu absolute here
		if( vect[i] < value)
		{
			value = vect[i];
			index = i;
		}

}
//Find the maximum number in a vector and return its value and index
void Vmax( double *vect, const int size, double &value, int &index )
{

	value = 1E-20;
	for(int i=0; i<size; i++)
		//May pu absolute here
		if( vect[i] > value)
		{
			value = vect[i];
			index = i;
		}

}

/* choose:
 *		0: max of x points
 *		1: max of y points
 */
double Datamax( const double *vect, const int size, int choose )
{
	double value = 1E-20;
	for(int i=0; i<size; i++)
		if( vect[2*i+choose] > value)
			value = vect[2*i+choose];

	return value;

}

/* choose:
 *		0: max of x points
 *		1: max of y points
 */
double Datamin( const double *vect, const int size, int choose )
{
	double value = 1E20;
	for(int i=0; i<size; i++)
		if( vect[2*i+choose] < value)
			value = vect[2*i+choose];

	return value;

}

/* choose:
 *		0: max of x points
 *		1: max of y points
 */
double Datamean( const double *vect, const int size, int choose )
{
	double sum = 0.0;

	for(int i=0; i<size; i++)
		sum += vect[2*i+choose];
	
	return sum/(double)size;

}

	



















