/*
 * Permission is hereby granted, free of charge, 
 * to any person obtaining a copy of this software and 
 * associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including 
 * without limitation the rights to use, copy, modify, 
 * merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom 
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice 
 * shall be included in all copies or substantial portions of the Software.
 * 
 * Users shall give appropriate references to the eNTERFACE'05 Website
 * (www.enterface.net) in scholarly literature for which this software is used or mentioned.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */


/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// The function declarations, which are used to calculate the errors for shapes
// Basic functions to find minimum, maximum and mean of a data set

#include <cmath>

#ifndef HelperFunctions_h
#define HelperFunctions_h

// Calculates euclidian norm of a vector whose size is two
double V2norm( double vect[2] );

// Takes the dot product of two vectors with length 2
double Vdot(double vect1[2], double vect2[2]);

// Finds the minimum entry of a vector with size "size"
// "value" is the minimum value and "index" is the index corr. to "value"
void Vmin( double *vect, const int size, double &value, int &index );

//Find the maximum number in a vector and return its value and index
void Vmax( double *vect, const int size, double &value, int &index );

//Finds the maximum point in the data set, choose determines whether to search x or y data
double Datamax( const double *vect, const int size, int choose );
//Finds the minimum point in the data set
double Datamin( const double *vect, const int size, int choose );
//finds the mean of the data set
double Datamean( const double *vect, const int size, int choose );

#endif