/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// The implementation of the functions defined in "LM_Minimizer.cpp"

#include "LM_Minimizer.h"
#include "LM_Shapes.h"
#include "LM_ShapeParams.h"
#include "LM_HelperFunctions.h"
#include "LM_FilterPoints.h"

#define NULL 0


// Call LM algorithm to find the optimum shape
void LMminimizer(double* data, const int dataSize, ShapeParam &parameters)
{

	//Initialize the constants
	double *x = new double[dataSize];	//The array to hold the error vector
	double p[8][6] ;	//Holds the raw parameters of the shapes
	double error[8] ;	//Holds the total errors for each shape

	//Parameters of LM algortihm defined in "lm.h"
	double opts[LM_OPTS_SZ], info[LM_INFO_SZ];
	opts[0]=LM_INIT_MU; opts[1]=NULL; opts[2]=NULL; opts[3]=NULL;
	opts[4]=LM_DIFF_DELTA;

	//Find the minimum, maximum and mean of the data for guessing initial conditions
	double mindata[2], maxdata[2], meandata[2];
	int i;

	mindata[0] = Datamin(data,dataSize,0);
	mindata[1] = Datamin(data,dataSize,1);
	maxdata[0] = Datamax(data,dataSize,0);
	maxdata[1] = Datamax(data,dataSize,1);
	meandata[0] = Datamean(data,dataSize,0);
	meandata[1] = Datamean(data,dataSize,1);

	// Call the circle function
	// Determine the initial conditions
	p[0][0] = meandata[0]; p[0][1]=meandata[1]; 
	p[0][2]=sqrt( pow(maxdata[0]-mindata[0],2)+pow(maxdata[1]-mindata[1],2) )/2.0;
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(circle, p[0], x, 3, dataSize, 150, opts, info, NULL, NULL, data);
	error[0] = info[1];


	//Call the circle function with different parameters
	p[1][0] = meandata[0]; p[1][1]=meandata[1]; 
	p[1][2]=sqrt( pow(maxdata[0]-mindata[0],2)+pow(maxdata[1]-mindata[1],2) );
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(circle, p[1], x, 3, dataSize, 80, opts, info, NULL, NULL, data);
	error[1] = info[1];

	// Call the rectangle function
	p[2][0] = meandata[0]-p[0][2]/1.3; p[2][1]=meandata[1]-p[0][2]/1.3; 
	p[2][2] = meandata[0]+p[0][2]/1.3; p[2][3]=meandata[1]-p[0][2]/1.3;
	p[2][4] = p[0][2];
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(rectangle, p[2], x, 5, dataSize, 150, opts, info, NULL, NULL, data);
	error[2] = info[1];


	// Call the rectangle function with different initial conditions
	p[3][0] = mindata[0]; p[3][1]=mindata[1]; 
	p[3][2] = maxdata[0]; p[3][3]=mindata[1];
	p[3][4] = maxdata[1] - mindata[1];
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(rectangle, p[3], x, 5, dataSize, 150, opts, info, NULL, NULL, data);
	error[3] = info[1];


	// Call the triangle function
	p[4][0] = mindata[0]; p[4][1]=mindata[1]; 
	p[4][2] = maxdata[0]; p[4][3]=mindata[1];
	p[4][4] = maxdata[0]; p[4][5]=maxdata[1];
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(triangle, p[4], x, 6, dataSize, 150, opts, info, NULL, NULL, data);
	error[4] = info[1];


	// Call the triangle function with different parameters
	p[5][0] = maxdata[0]; p[5][1]=maxdata[1]; 
	p[5][2] = mindata[0]; p[5][3]=maxdata[1];
	p[5][4] = mindata[0]; p[5][5]=mindata[1];
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(triangle, p[5], x, 6, dataSize, 150, opts, info, NULL, NULL, data);
	error[5] = info[1];

	
	// Call the ellipse function
	p[6][0] = p[0][2]*0.7; p[6][1]=-0.7*p[0][2];
	p[6][2] = p[0][2]*0.7; p[6][3]=p[0][2]*0.7;
	p[6][4] = p[0][0];     p[6][5] = p[0][1];
	for(i=0; i<dataSize; i++)
		x[i] =0;

	dlevmar_dif(ellipse, p[6], x, 6, dataSize, 180, opts, info, NULL, NULL, data);
	error[6] = info[1];


	// Calculate the normalized errors
	double normal, errormean=0;

	normal = sqrt( pow( maxdata[0]-mindata[0],2 ) + pow( maxdata[1] -mindata[1],2 ) ) * dataSize;
	for(i=0; i<7; i++)
	{
		error[i] /= normal;
		errormean += error[i];
	}
	errormean = errormean/7.0;

	// Check for nonshapes
	double minvalue; int index;
	Vmin(error, 7, minvalue, index);
	if( minvalue > 2.4 || (errormean > 6.0 && minvalue > 1.9 ) )
		error[7] = 0;
	else
		error[7] = 1E10;

	//////////////////////
	//for (int i=0; i<8; i++ )
	//	cout << error[i] << "\t";
	//cout << endl;
	//////////////////////


	/**** Prepare the output ******************************/

	// Find the index of the minimum error
	Vmin(error, 8, minvalue, index);
	
	// Write the parameters for the shape with minimum index
	switch(index)
	{

		// Check for the cases of circle and the ellipse
	case 0:case 1:case 6:
		Vmin(error, 2, minvalue, index);
		parameters.Type = 1;
		parameters.NumParams = 3;
		parameters.points = new double[3];
		//copy the parameters
		for(i=0; i<3; i++)
			parameters.points[i] = p[index][i];
		break;

		// Check for the case of rectangle
	case 2: case 3:
		parameters.Type = 2;
		parameters.NumParams = 8;

		// Get the parameters
		RectanglePoints(p[index], &(parameters.points) );

		break;

		// Check for the case of triangle
	case 4: case 5:
		parameters.Type = 3;
		parameters.NumParams = 6;

		parameters.points = new double[6];
		//copy the parameters
		for(i=0; i<6; i++)
			parameters.points[i] = p[index][i];
		break;

		// Check for nonshapes
	case 7:
		parameters.Type = 0;
		parameters.NumParams = 0;
		parameters.points = 0;
		break;

	} // End of switch

	// Delete variables
	delete x;

}

// Call this function if you have a 2 by "dataSize" data matrix
void LM_Interface(double** data,int dataSize, ShapeParam &parameters)
{
	// Copy the contents to an array
	double *newdata = new double[dataSize*2];
	for(int i=0; i<dataSize;i++)
	{
		newdata[2*i] = data[0][i];
		newdata[2*i+1] = data[1][i];
	}

	// Initialize Shape Parameters
	parameters.Type = 0;
	parameters.NumParams = 0;
	if( parameters.points != NULL)
	{
		delete parameters.points;
		parameters.points = NULL;
	}

	// Resample points
	UniformResample(&newdata, dataSize);

	// Call LM_minimizer
	LMminimizer(newdata, dataSize, parameters);

	delete newdata;

}













