/*
 * Permission is hereby granted, free of charge, 
 * to any person obtaining a copy of this software and 
 * associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including 
 * without limitation the rights to use, copy, modify, 
 * merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom 
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice 
 * shall be included in all copies or substantial portions of the Software.
 * 
 * Users shall give appropriate references to the eNTERFACE'05 Website
 * (www.enterface.net) in scholarly literature for which this software is used or mentioned.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */


/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// The definitions of the functions for fitting a geometric shape to a curve
// Read SourceGuide and Readme for more info

#include "LM_ShapeParams.h"
#include "lm.h"

#ifndef LM_Interface_h
#define LM_Interface_h


/*  Get a double data vector and return parameters of the recognized shape
 *	dataSize:   The length of the data vector
 *  data:       2 by "dataSize" matrix holding the points of the shape
 *  parameters: Holds the parameters of the recognized shape, see
 *              "ShapeParams.h" for the details of the struct
 *
 *  Call this function in order to incorporate this code to your project
 **************************************************************************/
void LM_Interface(double** data,int dataSize, ShapeParam &parameters);



/* The function to call the Levenberg-Marquardt non-linear least squares algorithm
 * to find the optimum parameters of circles, rectangles, triangles and ellipses
 * that the give the minimum total euclidian distance to the provided points
 ********************************************************************************/
void LMminimizer(double* data, const int dataSize, ShapeParam &parameters);

#endif
