/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// Functions to read data from file and to write data to file

#include "LM_ReadWrite.h"

#include <fstream>
#include <vector>
#include <iostream>

using namespace std;

bool ReadData(char *fname, double **data, int &dataSize)
{
	//open the file to read
	ifstream input;
	input.open(fname);
	if(input.fail())
	{
		return true; cerr << "File " << fname << "could not be opened" << endl;
	}

	vector<double> tempData;
	double dataX, dataY, dummyTimeStamp;

	while(!input.eof())
	{
		input >> dataX >> dataY >> dummyTimeStamp;
		tempData.push_back(dataX);
		tempData.push_back(dataY);
	}
	tempData.pop_back();
	tempData.pop_back();

	//Write the data to array

	(*data) = new double[tempData.size()];

	for(int i=0; i< tempData.size();i++)
		(*data)[i] = tempData[i];
	
	dataSize = tempData.size()/2;

	return false;
}

bool WriteData(char*fname, const double *data, int dataSize)
{

	//open the file to write
	ofstream output;
	output.open(fname);
	if(output.fail())
	{
		return true; cerr << "File " << fname << "could not be opened" << endl;
	}

	for(int i=0; i<dataSize; i++)
		output << data[2*i] << "\t" << data[2*i+1] << endl;

	return false;

}