/*
 * Permission is hereby granted, free of charge, 
 * to any person obtaining a copy of this software and 
 * associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including 
 * without limitation the rights to use, copy, modify, 
 * merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom 
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice 
 * shall be included in all copies or substantial portions of the Software.
 * 
 * Users shall give appropriate references to the eNTERFACE'05 Website
 * (www.enterface.net) in scholarly literature for which this software is used or mentioned.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */


/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

#ifndef ShapeParam_h
#define ShapeParam_h

//Structure to hold the parameters of the shapes
struct ShapeParam
{
	ShapeParam(){
		Type = 0;
		NumParams = 0;
		points=0;
	};
public:
	/** Type:
	 *		0: Not recognized
	 *		1: Circle
	 *		2: Rectangle
	 *		3: Triangle
	 ****************************/
	int Type;

	/** NumParams: Number of parameters of the shape
	 *		0 for nonshape
	 *		3 for Circle: [ x pos of center, y pos of center, radius r]
	 *		8 for rectangle: [ x pos of first edge, y pos of first edge, x2, y2, x3, y3, x4, y4 ]
	 *		6 for triangle: [ x pos of first edge, y pos of first edge, x2, y2, x3, y3 ]
	 ********************************************************************************************/
	int NumParams;

	double *points;	// The points are hold in a one dimensional array in a form [ x1,y1, x2,y2 ...]
};

#endif