/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

// The Implementation of the functions defined in "Shapes.h"

#include "LM_Shapes.h"
#include "LM_HelperFunctions.h"

#include <cmath>


//Calculate the total error for a circle
void circle(double *p, double *x, int m, int n, void *data)
{
	double* pic = (double*) data;
	for( int i=0; i<n;i++)
		x[i] = sqrt( pow(pic[2*i]-p[0],2) + pow(pic[2*i+1]-p[1],2) ) - p[2];
}

void triangle(double *p, double *x, int m, int n, void *data)
{
	double* pic = (double*) data;

	double A[2], B[2], C[2];

	//calculate the points A, B and C
	A[0] = p[0];
	A[1] = p[1];
	B[0] = p[2];
	B[1] = p[3];
	C[0] = p[4];
	C[1] = p[5];

	//Calculate the vectors between the points
	double Vab[2], Vbc[2], Vca[2];
	Vab[0] = B[0] - A[0];
	Vab[1] = B[1] - A[1];
	Vbc[0] = C[0] - B[0];
	Vbc[1] = C[1] - B[1];
	Vca[0] = A[0] - C[0];
	Vca[1] = A[1] - C[1];
	
	//calculate the smallest distance to the triangles side
	double Vpa[2], Vpb[2], Vpc[2];
	double costheta[3], distance[3];
	double value;
	int index;

	for(int i=0; i<n; i++)
	{
		//Calculate the vectors from the point to the edges
		Vpa[0] = pic[2*i] - A[0];
		Vpa[1] = pic[2*i+1] - A[1];
		Vpb[0] = pic[2*i] - B[0];
		Vpb[1] = pic[2*i+1] - B[1];
		Vpc[0] = pic[2*i] - C[0];
		Vpc[1] = pic[2*i+1] -C[1];
		
		//Calculate the cosine of the angle
		costheta[0] = Vdot(Vpa,Vab)/(V2norm(Vpa)*V2norm(Vab));
		costheta[1] = Vdot(Vpb,Vbc)/(V2norm(Vpb)*V2norm(Vbc));
		costheta[2] = Vdot(Vpc,Vca)/(V2norm(Vpc)*V2norm(Vca));

		//Calculate the distance
		distance[0] = V2norm(Vpa)*sqrt( 1- pow(costheta[0],2));
		distance[1] = V2norm(Vpb)*sqrt( 1- pow(costheta[1],2));
		distance[2] = V2norm(Vpc)*sqrt( 1- pow(costheta[2],2));

		//find the minimum distance
		Vmin( distance, 3, value, index);
		x[i] = distance[index];
	}

}


//Calculate the total error for the rectangle
void rectangle(double *p, double *x, int m, int n, void *data)
{
	double* pic = (double*) data;

	double A[2], B[2], C[2], D[2];
	double Vab[2], Vbc[2], Vcd[2], Vda[2], height[2];
	//Calculate the position of the points
	A[0] = p[0];
	A[1] = p[1];
	B[0] = p[2];
	B[1] = p[3];
	Vab[0] = B[0] -A[0];
	Vab[1] = B[1] - A[1];
	height[0] = -1*Vab[1]/V2norm(Vab);
	height[1] = Vab[0]/V2norm(Vab);
	C[0] = B[0] + height[0]*p[4];
	C[1] = B[1] + height[1]*p[4];
	D[0] = A[0] + height[0]*p[4];
	D[1] = A[1] + height[1]*p[4];
	Vbc[0] = C[0] - B[0];
	Vbc[1] = C[1] - B[1];
	Vcd[0] = D[0] - C[0];
	Vcd[1] = D[1] - C[1];
	Vda[0] = A[0] - D[0];
	Vda[1] = A[1] - D[1];

	double Vpa[2],Vpb[2], Vpc[2], Vpd[2]; 
	double cosTheta[4], distance[4], value;
	int index;
	for(int i=0; i<n;i++)
	{
		//calculate the vectors from points to the edges
		Vpa[0] = A[0] - pic[2*i];
		Vpa[1] = A[1] - pic[2*i+1];
		Vpb[0] = B[0] - pic[2*i];
		Vpb[1] = B[1] - pic[2*i+1];
		Vpc[0] = C[0] - pic[2*i];
		Vpc[1] = C[1] - pic[2*i+1];
		Vpd[0] = D[0] - pic[2*i];
		Vpd[1] = D[1] - pic[2*i+1];

		//calculate the angles with the sides
		cosTheta[0] = Vdot(Vpa,Vab)/(V2norm(Vpa)*V2norm(Vab));
		cosTheta[1] = Vdot(Vpb,Vbc)/(V2norm(Vpb)*V2norm(Vbc));
		cosTheta[2] = Vdot(Vpc,Vcd)/(V2norm(Vpc)*V2norm(Vcd));
		cosTheta[3] = Vdot(Vpd,Vda)/(V2norm(Vpd)*V2norm(Vda));

		//Calculate teh distances to the sides
		distance[0] = V2norm(Vpa)*sqrt(1 - pow(cosTheta[0],2) );
		distance[1] = V2norm(Vpb)*sqrt(1 - pow(cosTheta[1],2) );
		distance[2] = V2norm(Vpc)*sqrt(1 - pow(cosTheta[2],2) );
		distance[3] = V2norm(Vpd)*sqrt(1 - pow(cosTheta[3],2) );

		//Find the minimum distance
		Vmin(distance, 4, value, index);
		x[i] = distance[index];
	}//End of for loop

}//end of function



//Calculate the total error for the ellipse
void ellipse(double *p, double *x, int m, int n, void *data)
{

	double* pic = (double*) data;

	double ellipseX[ELLPTS], ellipseY[ELLPTS];
	int i;
	
	//Calculate the points of the ellipse
	for(i=0; i<ELLPTS; i++)
	{
		ellipseX[i] = cos(2.0*PI*i/(double)ELLPTS)*p[0] + sin(2.0*PI*i/(double)ELLPTS)*p[2] + p[4];
		ellipseY[i] = cos(2.0*PI*i/(double)ELLPTS)*p[1] + sin(2.0*PI*i/(double)ELLPTS)*p[3] + p[5];
	}

	double distance[ELLPTS], value;
	int index;
	//Calculate the distance to the points
	for(i=0; i<n;i++)
		//Calculate the minimum distance to the ellipse
		for(int j=0; j<ELLPTS;j++)
		{
			distance[j] = sqrt( pow( pic[2*i]-ellipseX[j],2) + pow( pic[2*i+1]-ellipseY[j],2) );
			Vmin( distance, ELLPTS, value, index);
			x[i] = distance[index];
		}

}
        
void RectanglePoints(const double *params, double **points)
{
	
	double Vab[2], height[2];
	(*points) = new double[8];
	//Calculate the position of the (*points)
	(*points)[0] = params[0];
	(*points)[1] = params[1];
	(*points)[2] = params[2];
	(*points)[3] = params[3];
	Vab[0] = (*points)[2] - (*points)[0];
	Vab[1] = (*points)[3] - (*points)[1];
	height[0] = -1*Vab[1]/V2norm(Vab);
	height[1] = Vab[0]/V2norm(Vab);
	(*points)[4] = (*points)[2] + height[0]*params[4];
	(*points)[5] = (*points)[3] + height[1]*params[4];
	(*points)[6] = (*points)[0] + height[0]*params[4];
	(*points)[7] = (*points)[1] + height[1]*params[4];

}



