/*
 * Permission is hereby granted, free of charge, 
 * to any person obtaining a copy of this software and 
 * associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including 
 * without limitation the rights to use, copy, modify, 
 * merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom 
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice 
 * shall be included in all copies or substantial portions of the Software.
 * 
 * Users shall give appropriate references to the eNTERFACE'05 Website
 * (www.enterface.net) in scholarly literature for which this software is used or mentioned.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR 
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR 
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */


/***********************************
 * Serdar Kemal Balci              *
 * serdar.balci@gmail.com          *
 * Enterface Workshop Summer 2005  *
 ***********************************/

/* Funcion declarations to calculate the errors for shapes
 * The functions calculate the total error for given parameters for their geometrical shapes
 * The total error is not square summed, instead each error for each point is returned in a vector
 * for efficient search of the LM algorithm
 */

#ifndef ShapeParams_h
#define ShapeParams_h

#define PI 3.1415926535897932384626433832795
// Number of points in the Ellipse
// Increase of this value gives better; but, slower results
#define ELLPTS 120

/* Calculate the total error for the circle
 * double *p: holds the parameters of the circle, x pos of center, y pos of center and radius
 * double *x: the vector which holds the minimum distance of the points in the data tp the shape
 * int m: size of the parameters
 * int n: size of the vector x
 * void *data: data file containing the coordinates of the points
 *********************************************************************/
void circle(double *p, double *x, int m, int n, void *data);

// Calculates the total error to a triangular shape
// Parameters are similar to the circle
void triangle(double *p, double *x, int m, int n, void *data);

// Calculates the total error to a rectangular shape
// Parameters are similar to the circle
void rectangle(double *p, double *x, int m, int n, void *data);

// Calculates the total error to a triangular shape
// Parameters are similar to the circle
void ellipse(double *p, double *x, int m, int n, void *data);



// Helper functions to calculate the position of the points from the paramaters
// Calculates the points of the rectangle from the parameters
void RectanglePoints(const double *params, double **points);


#endif