/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

Author: S. Raidt, E.I. Leon      e-mail: Stephan.Raidt@icp.inpg.fr, eloisa.i@caramail.com
*/


function [Xfin,Yfin]=prueba_filtro(shape,number)

filename = sprintf('seb_%s_trace%d.unp',shape,number);
raw = load(filename);
X=raw(:,1)-mean(raw(:,1));
Y=raw(:,2)-mean(raw(:,2));
T_stamp = raw(:,3)

plot(X,Y,'.');
hold on
plot(X,Y);

[N,M]=size(X);
Xfin=[];
Yfin=[];

%neighbours
n=3;

%threshold Ta to delete segments outside the closed shape
dmean=0;
for (i=1:N-1)
    Dx=X(i)-X(i+1);
    Dy=Y(i)-Y(i+1);
    dmean=dmean+sqrt((Dx*Dx)+(Dy*Dy));       
end
dmean=dmean/(N-1);
Ta=dmean*2;
Tb=4*dmean;


m=1;%index of new vector points Xnew and Ynew
for (i=1:N)
    Dgeo=0;
    if((i-n-1)>=1)
        for (j=(i-n-1):i-1)
            Dx=abs(X(j)-X(j+1));
            Dy=abs(Y(j)-Y(j+1));
            d=sqrt((Dx*Dx)+(Dy*Dy));   %esta es la distancia euclidea
            Dgeo=Dgeo+d;     %esta es la suma de las distancias anteriores
        end
    
    %threshold Tb to delete very small segments that not influence the shape
%     for (j=(i-n-1):i-1)
%         Dx=abs(X(j)-X(j+1));
%         Dy=abs(Y(j)-Y(j+1));
%         dmean=dmean+sqrt((Dx*Dx)+(Dy*Dy));       
%     end
%     
%     dmean=dmean/(n+1);
%     Tb=dmean*n;
 %%%%%%%%%%%%%%%%%%%%%%%%%
    
        if (Dgeo>Tb)
            Xnew(m)=X(i);
            Ynew(m)=Y(i);
            m=m+1;
        else 
            for (j=(i-n-1):i)
                Xnew(m)=X(j);
                Ynew(m)=Y(j);
                m=m+1;
            end
        end
    

%to delete segments out the closed shape
%here we have to processing Xnew and Ynew
        lim_inf=1;
        [Nnew,M]=size(Xnew);
%we have to use Nnew now
        for (k=1:Nnew)
    
            Dx=abs(Xnew(Nnew)-Xnew(k));
            Dy=abs(Ynew(Nnew)-Ynew(k));
            d=sqrt((Dx*Dx)+(Dy*Dy));   %esta es la distancia euclidea
            if (d<Ta)
                lim_inf=k;
                k=Nnew;
            end
        end
 
        lim_sup=Nnew;

        for (l=(Nnew-1):-1:1)
            Dx=abs(Xnew(l)-Xnew(k));
            Dy=abs(Ynew(l)-Ynew(k));
            d2=sqrt((Dx*Dx)+(Dy*Dy));   %esta es la distancia euclidea
       
            if (d>d2)
                lim_sup=l;
                l=1;
            end
        end

        j=1;%index of vector points Xfin and Yfin

        for(i=lim_inf:lim_sup)
            Xfin(j)=Xnew(i);
            Yfin(j)=Ynew(i);
            j=j+1;
        end
    end
end

figure
plot(Xfin,Yfin,'.');
hold on
plot(Xfin,Yfin);