/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

Author: S. Raidt, E.I. Leon      e-mail: Stephan.Raidt@icp.inpg.fr, eloisa.i@caramail.com
*/


function [circle]=is_circle(a);

%a is the matrix with the data from Sebastien
%circle is a boolean to say:
%1 is a circle
%0 is not a circle (or is a too bad circle)

%To have the middle point
X=a(:,1)-mean(a(:,1));
Y=a(:,2)-mean(a(:,2));

%To get the polar coordinates
[theta, rho]=cart2pol(X,Y);

%To now if is a circle or not
thresh=150; 
%we can change it: all the squares and triangles have it bigger than this
%and all the circles smaller? we have to know it.
dif=max(rho)-min(rho);
if (dif<thresh)
    circle=1;
else
    circle=0;
end

