/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

Author: S. Raidt, E.I. Leon      e-mail: Stephan.Raidt@icp.inpg.fr, eloisa.i@caramail.com
*/



%function treat_trace(shape,number)
% Copyright (c) 2005 Facult? Polytechnique de Mons (eNTERFACE'05 workshop) -
% Names of YOUR team members
% 
% Permission is hereby granted, free of charge, to any person obtaining a
% copy of this software and associated documentation files (the "Software"),
% to deal in the Software without restriction, including without limitation
% the rights to use, copy, modify, merge, publish, distribute, sublicense,
% and/or sell copies of the Software, and to permit persons to whom the
% Software is furnished to do so, subject to the following conditions:
% 
% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.
% 
% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is
% used or mentioned.
% 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
% THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
% DEALINGS IN THE SOFTWARE.

function treat_trace(shape,number)

filename = sprintf('seb_%s_trace%d.unp',shape,number);
raw = load(filename);
X=raw(:,1)-mean(raw(:,1));
Y=raw(:,2)-mean(raw(:,2));
T_stamp = raw(:,3)
[length_raw,width_raw] = size(raw)

[THETA,RHO] = cart2pol(X,Y)

[a,b]=find((THETA(1:length_raw-1) - THETA(2:length_raw)) > 0)



%if (THETA(10)-THETA(5)) < 0
    rotSens=-1;
%    find(THETA[1:length_raw-1] - THETA[2:length_raw] 
%elseif (THETA(10)-THETA(5)) > 0
%    rotSens=1
%else
%    error('There is a problem with the angle');
%end

figure
polar(THETA,RHO,'b')
hold on
polar(THETA,RHO,'m.')
figure
polar(THETA(a),RHO(a),'g')
hold on
polar(THETA(a),RHO(a),'b+')

figure
polar(THETA,RHO,'b')
hold on
polar(THETA,RHO,'m.')

[a,b]=sort(THETA);
RHO=RHO(b);
THETA=THETA(b);
T_stamp=T_stamp(b);

%figure
%polar(THETA,RHO,'b')
%hold on
%polar(THETA,RHO,'m.')


diff_rho=[];
diff_rho(1)= (RHO(2)-RHO(length_raw)) / (THETA(2)-THETA(length_raw));
for i=2:length_raw-1
    diff_rho(i)= (RHO(i+1)-RHO(i-1)) / (THETA(i+1)-THETA(i-1));
end
diff_rho(length_raw)= (RHO(1)-RHO(length_raw-1)) / (THETA(1)-THETA(length_raw-1));

figure
plot(THETA,RHO,'g+')
hold on
plot(THETA,RHO,'m')

figure
plot(THETA,diff_rho,'m')
hold on
plot(THETA,diff_rho,'g*')
shit=[THETA,RHO,T_stamp]

for i=1:length_raw-1
    if T_stamp(i+1) - T_stamp(i) > 0
        T_stamp(i+1)
        T_stamp(i)
        T_stop = T_stamp(i+1)
        T_start = T_stamp(i)
        break;
    end
end
excludeElem = find(T_stamp<T_start | T_stamp>T_stop)
THETA(excludeElem)=[];
RHO(excludeElem)=[];
T_stamp(excludeElem)=[];

[X,Y] = pol2cart(THETA,RHO)
X=X-mean(X);
Y=Y-mean(Y);
[THETA,RHO] = cart2pol(X,Y);

[a,b]=sort(THETA);
RHO=RHO(b);
THETA=THETA(b);
T_stamp=T_stamp(b);

figure
polar(THETA,RHO,'b')
hold on
polar(THETA,RHO,'m.')

figure
plot(THETA,RHO,'g+')
hold on
plot(THETA,RHO,'m')

[length_raw,width_raw] = size(X);
diff_rho=[];
diff_rho(1)= (RHO(2)-RHO(length_raw)) / (THETA(2)-THETA(length_raw));
for i=2:length_raw-1
    diff_rho(i)= (RHO(i+1)-RHO(i-1)) / (THETA(i+1)-THETA(i-1));
end
diff_rho(length_raw)= (RHO(1)-RHO(length_raw-1)) / (THETA(1)-THETA(length_raw-1));

figure
plot(THETA,diff_rho,'m')
hold on
plot(THETA,diff_rho,'g*')