/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

Author: K. Moustakas      e-mail: moustak@iti.gr

*/

// client.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>

#ifdef WIN32
#include <winsock2.h>
#include "convert.h"
#endif

#define TIME_TO_STOP	1
#define MAXHOSTNAME	1024
#define HOSTNAME	"iti-80"
#define MSGLEN		300
#define MAXLINE		1024
#define CGFFNAME	"config.txt"

int call_socket(char *, unsigned short);
int writeData(int fd, char *buf);

int
main(int argc, char *argv[])
{
	int  *sockFD, *portno;
	char line[MAXLINE], **ip;

#ifdef WIN32
	//verify the winsock version is at least version 2.0
	WORD wVersionRequested = MAKEWORD( 2, 0 );
	WSADATA wsaData;
	int err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 )
	{
		printf("Current winsock version 2.0 required\n");
		exit(1);
	}
#endif


	sockFD = (int *) malloc(sizeof(int));
	ip = (char **) malloc(sizeof(char *));

	ip[0] = (char *) malloc(MAXHOSTNAME*sizeof(char));
	memset(ip[0], 0, MAXHOSTNAME*sizeof(char));
	portno = (int *) malloc(sizeof(int));

	//strcpy(ip[0], "10.104.11.43");
	strcpy(ip[0], "localhost");
	portno[0] = 40000;
	sockFD[0] = call_socket(ip[0], portno[0]);
	printf("connecting to server %s:%d\n",ip[0],portno[0]);

	while (1)
	{
		printf("enter data:");
		scanf("%s",line);
		//printf("|%s| (%d)\n",line,strcmp(line,"."));
		if (strcmp(line,".\0") == 0)
		{
			writeData(sockFD[0],"------------");
			break;
		}
		else
		{
			writeData(sockFD[0],line);
		}

	}
	closesocket(sockFD[0]);

	free(portno);
	free(ip[0]);
	free(ip);
	free(sockFD);
	return 0;
}


int
writeData(int fd, char *buf)
{
	return send(fd, buf, MSGLEN, 0);
}

int 
call_socket(char *hostname, unsigned short portnum)
{
	struct sockaddr_in sa;
	struct hostent     *hp;
	int s;

	if ((hp= gethostbyname(hostname)) == NULL)
	{
		return(-1);
	}

	memset(&sa,0,sizeof(sa));
	memcpy((char *)&sa.sin_addr,hp->h_addr,hp->h_length);
	sa.sin_family= hp->h_addrtype;
	sa.sin_port= htons((u_short)portnum);

	if ((s= socket(hp->h_addrtype,SOCK_STREAM,0)) < 0)
		return(-1);
	if (connect(s,(struct sockaddr *)&sa,sizeof sa) < 0)
	{
		closesocket(s);
		return(-1);
	}
	return(s);
}

