/*Copyright (c) 2005 Faculte Polytechnique de Mons (eNTERFACE'05 workshop) -
Team members
D. Tzovaras, K. Moustakas, S. Balci, E. Ibanez, O. Bernier, S. Carbini, 
M. Dimiccoli, M Mancas, S. Raidt, J.-E. Viallet, E. Yagci

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

Author: K. Moustakas      e-mail: moustak@iti.gr

*/


// server.cpp : Defines the entry point for the console application.
//

//#include "stdafx.h"

#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
//#include <unistd.h>
#include <sys/types.h>
#include <winsock2.h>

#define TIME_TO_STOP	0
#define WAIT_FOR_NEXT	1
#define MAXHOSTNAME	1024
#define STOP_STR	"------------"
#define MSGLEN		12
#define HOST_NAME_MAX 255


int getConnection(int);
int establish(unsigned short);
int readData(int, char *, int);
int ListenSocket(int);

int
main(int argc, char *argv[])
{
	int   s, t, res, portnum;
	char hostname[HOST_NAME_MAX];
	struct hostent *h;

	//choose listening port
	if (argc == 2) 
		portnum = atoi(argv[1]);
	else
		portnum = 40000;

	//verify the winsock version is at least version 2.0
	WORD wVersionRequested = MAKEWORD( 2, 0 );
	WSADATA wsaData;
	int err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 )
	{
		printf("Current winsock version 2.0 required\n");
		exit(1);
	}

	res = gethostname(hostname,HOST_NAME_MAX);
	if (res == 0)
	{
		if ((h = gethostbyname(hostname)) == NULL)
			exit(1);

		printf("Host name  : %s:%d\n", h->h_name, portnum);
		printf("IP Address : %s\n", inet_ntoa(*((struct in_addr *)h->h_addr)));

	}

	if ((s = establish(portnum)) < 0) 
	{
		perror("establish");
		exit(1);
	}

	while (1)
	{
		printf("Waiting for connection\n");
		if ((t = getConnection(s)) < 0)
		{
			if (errno == EINTR)
				continue;
			perror("accept");
			exit(1);
		}
		else
		{
			printf("Accepted connection\n");
			fflush(stdout);
			break;
		}
	}

	while (1)
	{
		res = ListenSocket(t);
		if (res == TIME_TO_STOP)
			break;
	}
	closesocket(s);

	return 0;
}

int
ListenSocket(int t)
{
	int  cnt;
	char buf[MSGLEN], str[MSGLEN+1];

	fflush(stdout);
	cnt = readData(t, buf, MSGLEN);
	printf("Read data returns\n"); 
	fflush(stdout);
	
	strncpy(str,buf,MSGLEN);
	str[12] = '\0';
	printf("msg: |%s|\n",str);

	if (strncmp(buf,STOP_STR,MSGLEN) == 0)
	{
		printf("Time to stop\n");
		return TIME_TO_STOP;
	}
	return WAIT_FOR_NEXT;
}

int
readData(int s, char *buf, int n)
{
	int res = recv(s, buf, MSGLEN, 0);//MSG_WAITALL);

	if (errno == EAGAIN)
		printf("non blocking socket\n");

	return res;
}

int 
establish(unsigned short portnum)
{
	char   myname[MAXHOSTNAME+1];
	int    s;
	struct sockaddr_in sa;
	struct hostent *hp;

	memset(&sa,0,sizeof(struct sockaddr_in));
	gethostname(myname,MAXHOSTNAME);
	hp = gethostbyname(myname);
	if (hp == NULL)
		return(-1);
	sa.sin_family = hp->h_addrtype;
	sa.sin_port = htons(portnum);

	if ((s = socket(AF_INET,SOCK_STREAM,0)) < 0)
		return(-1);

	if (bind(s,(struct sockaddr *) &sa,sizeof(struct sockaddr_in)) < 0) 
	{
		closesocket(s);
		return(-1);
	}
	listen(s,3);
	return(s);
}


int 
getConnection(int s)
{
	int t;

	if ((t = accept(s,NULL,NULL)) < 0)
		return(-1);
	return(t);
}
