#include <windows.h>
#include <mmsystem.h>
#pragma comment( lib, "winmm.lib" )

#include "sonifier.h"
#include <iostream>
#include <string.h>
#include <time.h>

time_t gStart, gEnd;

/********************************************************
 * RGB to HSL conversion                                *
 * http://en.wikipedia.org/wiki/HSL_color_space version *
 ********************************************************/
struct hslColor rgb2hsl( struct rgbColor RGBvalue )
{
	double rgb[ 3 ];
	struct hslColor hsl;

	// normalize rgb values to [ 0 ; 1 ]
	rgb[ 0 ] = static_cast< double >( RGBvalue.r ) / 255;
	rgb[ 1 ] = static_cast< double >( RGBvalue.g ) / 255;
	rgb[ 2 ] = static_cast< double >( RGBvalue.b ) / 255;

//	std::cout << "r:" << rgb[ 0 ] << "r:" << rgb[ 0 ] << "r:" << rgb[ 0 ] << 

	// define some useful values
	double minimum, maximum, difference, sum;
	minimum = min( rgb[ 0 ], min( rgb[ 1 ], rgb[ 2 ] ) );
	maximum = max( rgb[ 0 ], max( rgb[ 1 ], rgb[ 2 ] ) );

	difference = maximum - minimum;
	sum = maximum + minimum;
	
	//-----HSL COMPUTATION-----\\

	// case where MIN = MAX -> grey
	if( difference < EPSILON && difference > -EPSILON )
	{
		hsl.h = 0;
		hsl.s = 0;
	}
	// otherwise compute hue and saturation normally
	else
	{
		// compute hue
		if( maximum == rgb[ 0 ] )
			hsl.h = ( rgb[ 1 ] - rgb[ 2 ] ) * 60 / difference;
		else if ( maximum == rgb[ 1 ] )
			hsl.h = ( rgb[ 2 ] - rgb[ 0 ] ) * 60 / difference + 120;
		else
			hsl.h = ( rgb[ 0 ] - rgb[ 1 ] ) * 60 / difference + 240;

		if( hsl.h < 0 )
			hsl.h += 360;

		// compute saturation
		if( sum > 1 )
			hsl.s = difference / ( 2 - sum );
		else
			hsl.s = difference / sum;
	}

	// compute luminance
	hsl.l = sum / 2;

	return hsl;
}

/********************************************************
 * Color conversion from string to HSL values           *
 ********************************************************/
struct hslColor convertColors( char * colors )
{
	char cred[ 3 ], cgreen[ 3 ], cblue[ 3 ];
	struct rgbColor rgb;

	// copy the string values into different variables
	memcpy( cred,	&( colors[  2 ] ), 3 * sizeof( char ) );
	memcpy( cgreen,	&( colors[  6 ] ), 3 * sizeof( char ) );
	memcpy( cblue,	&( colors[ 10 ] ), 3 * sizeof( char ) );

	// convert text rgb value to integer values
	rgb.r = atoi( cred		);
	rgb.g = atoi( cgreen	);
	rgb.b = atoi( cblue		);

	return(	rgb2hsl( rgb ) );
}

/********************************************************
 * Mapping from hsl color to quantized color            *
 ********************************************************/
SimpleColor instrumentMapping( struct hslColor hsl )
{
	if( hsl.s < .05  || hsl.l < .15 || hsl.l > .9 )
		return GREY;
	else if( hsl.h > 15. && hsl.h <= 70. )
		return YELLOW;
	else if( hsl.h > 70. && hsl.h <= 155. )
		return GREEN;
	else if( hsl.h > 155. && hsl.h <= 210. )
		return CYAN;
	else if( hsl.h > 210. && hsl.h <= 255. )
		return BLUE;
	else if( hsl.h > 255. && hsl.h <= 325. )
		return MAGENTA;
	else
		return RED;
}

/********************************************************
 * Mapping from hsl color to quantized color            *
 ********************************************************/
SimpleColor sonify( char * colorString, SimpleColor old )
{
	// transform the rgb string into a hsl structure
	struct hslColor hsl = convertColors( colorString );

	std::cout << "H: " << hsl.h;
	std::cout << " S: " << hsl.s;
	std::cout << " L: " << hsl.l;

	// get the major color that has to be sonified
	SimpleColor c = instrumentMapping( hsl );

	// map color to instrument
	char * wavefile;
	switch( c )
	{
	case GREY:
		std::cout << "Received grey color" << std::endl;
		wavefile = BASS;
		break;
	case RED:
		std::cout << "Received red color" << std::endl;
		wavefile = OBOE;
		break;
	case YELLOW:
		std::cout << "Received yellow color" << std::endl;
		wavefile = VIOLIN;
		break;
	case GREEN:
		std::cout << "Received green color" << std::endl;
		wavefile = FLUTE;
		break;
	case CYAN:
		std::cout << "Received cyan color" << std::endl;
		wavefile = TRUMPET;
		break;
	case BLUE:
		std::cout << "Received blue color" << std::endl;
		wavefile = PIANO;
		break;
	case MAGENTA:
		std::cout << "Received magenta color" << std::endl;
		wavefile = SAX;
		break;
	}

	( void )time( &gEnd );
	if( c != old || ( gEnd - gStart ) > .35 )
	{
		if( sndPlaySound( wavefile, SND_ASYNC | SND_NODEFAULT ) )
			( void )time( &gStart );
		else
			std::cout << "Didn't find file " << wavefile << std::endl;
	}

	return c;
}
