/* Socket server for color sonification */
#include <iostream>
#include <winsock.h>
#pragma comment( lib, "ws2_32.lib" )

#include "sonifier.h"

#define PORTNUM		40000
#define MAXHOSTNAME	255
#define MSGLEN		14

SimpleColor	gLastColor	= NOCOLOR;

//---------- Declaration of functions ----------\\

SOCKET				establish		( unsigned short	);
void				getSocketError	( int				);
int					ListenSocket	( int				);
int					readData		( int, char*, int	);
unsigned __stdcall	SocketThread	( void				);

//----------------------------------------------\\

void getSocketError( int error )
{
	switch( error )
	{
	case WSANOTINITIALISED:
		std::cout << "WSANOTINITIALISED" << std::endl;
		break;
	case WSAENETDOWN:
		std::cout << "WSAENETDOWN" << std::endl;
		break;
	case WSAEADDRINUSE:
		std::cout << "WSAEADDRINUSE" << std::endl;
		break;
	case WSAEINTR:
		std::cout << "WSAEINTR" << std::endl;
		break;
	case WSAEINPROGRESS:
		std::cout << "WSAEINPROGRESS" << std::endl;
		break;
	case WSAEALREADY:
		std::cout << "WSAEALREADY" << std::endl;
		break;
	case WSAEADDRNOTAVAIL:
		std::cout << "WSAEADDRNOTAVAIL" << std::endl;
		break;
	case WSAEAFNOSUPPORT:
		std::cout << "WSAEAFNOSUPPORT" << std::endl;
		break;
	case WSAECONNREFUSED:
		std::cout << "WSAECONNREFUSED" << std::endl;
		break;
	case WSAEFAULT:
		std::cout << "WSAEFAULT" << std::endl;
		break;
	case WSAEINVAL:
		std::cout << "WSAEINVAL" << std::endl;
		break;
	case WSAEISCONN:
		std::cout << "WSAEISCONN" << std::endl;
		break;
	case WSAENETUNREACH:
		std::cout << "WSAENETUNREACH" << std::endl;
		break;
	case WSAEMFILE:
		std::cout << "WSAEMFILE" << std::endl;
		break;
	case WSAENOBUFS:
		std::cout << "WSAENOBUFS" << std::endl;
		break;
	case WSAENOTSOCK:
		std::cout << "WSAENOTSOCK" << std::endl;
		break;
	case WSAEOPNOTSUPP:
		std::cout << "WSAEOPNOTSUPP" << std::endl;
		break;
	case WSAETIMEDOUT:
		std::cout << "WSAETIMEDOUT" << std::endl;
		break;
	case WSAEWOULDBLOCK:
		std::cout << "WSAEWOULDBLOCK" << std::endl;
		break;
	case WSAEACCES:
		std::cout << "WSAEACCES" << std::endl;
		break;
	}
}

SOCKET establish( unsigned short portnum )
{
	char				myname[ MAXHOSTNAME + 1 ];
	SOCKET				sock;
	struct sockaddr_in	saddr;
	struct hostent *	hp;

	memset( &saddr, 0, sizeof( struct sockaddr_in ) );
	gethostname( myname, MAXHOSTNAME );

	if ( ( hp = gethostbyname( myname ) ) == NULL)
		return( -1 );
	saddr.sin_family	= hp->h_addrtype;
	saddr.sin_port		= htons( portnum );

	if( ( sock = socket( AF_INET, SOCK_STREAM, 0 ) ) < 0 )
	{
		std::cerr << "socket function crashed with error " << WSAGetLastError();
		return( -1 );
	}

	// Binding
	if( bind( sock, (struct sockaddr *)&saddr, sizeof( struct sockaddr_in ) ) < 0 ) 
	{
		closesocket( sock );
		std::cerr << "Error binding" << std::endl;
		getSocketError( WSAGetLastError() );
		return( -1 );
	}

	// Listening
	if( listen( sock, 3 ) == SOCKET_ERROR )
	{
		std::cerr << "Can't hear you, ech hab bananasohre...";
		getSocketError( WSAGetLastError() );
		closesocket( sock );
		return( -1 );
	}

	return( sock );
}


int readData( int sock, char * buffer, int n )
{
	int result = recv( sock, buffer, MSGLEN, 0 );

	if( errno == EAGAIN )
		std::cerr << "non blocking socket";

	return result;
}

int ListenSocket( int csock )
{
	int  cnt, res;
	char buffer[ MSGLEN ], str[ MSGLEN + 1 ];

	memset( buffer, 0, MSGLEN );

	fflush( stdout );
	cnt = readData( csock, buffer, MSGLEN );

	strncpy( str, buffer, MSGLEN);
	str[ MSGLEN ] = '\0';

	// sonify the color only if the first value is '1'
	if( str[ 0 ] == '1' )
	{
		std::cout << "SONIFY: ";
		unsigned int i = 1;
		while( str[ i ] != '\0' )
		{
			std::cout << str[ i ];
			++i;
		}
		std::cout << std::endl;
		gLastColor = sonify( str, gLastColor );
		res = 0;
	}/*
	else if( str[ 0 ] == 'x' )
	{
		std::cout << "Time to stop" << std::endl;
		res = 1;;
	}*/
	else if( str[ 0 ] == '0' )
	{
		std::cout << "Do not sonify..." << std::endl;
		res = 0;
	}

	return res;
}


unsigned __stdcall SocketThread()
{
	// prepare socket... must be done for windows
	WSADATA WSAData;
	if( WSAStartup( MAKEWORD( 2, 0 ), &WSAData ) != 0 )
	{
		std::cerr << "Winsock version 2.0 required.";
		return 1;
	}

	// get host name and IP address
	char hostname[ MAXHOSTNAME ];
	struct hostent * h;

	if( gethostname( hostname, MAXHOSTNAME ) == 0)
	{
		if( ( h = gethostbyname( hostname ) ) == NULL )
			return 1;

		std::cout << "Host name  :" << h->h_name << ":" << PORTNUM << std::endl;
		std::cout << "IP Address :" << inet_ntoa( *( (struct in_addr *)h->h_addr) );
		std::cout << std::endl;
	}

	// establish listening server
	SOCKET ssock;
	if( ( ssock = establish( PORTNUM ) ) < 0 ) 
	{
		std::cerr << "establish failed";
		return 1;
	}

	// waiting for a client connection
	SOCKET connect_sock;
	while( true )
	{
		std::cout << "Waiting for the client to connect" << std::endl;
		if( ( connect_sock = accept( ssock, NULL, NULL ) ) < 0 )
		{
			if( errno == EINTR )
				continue;
			std::cerr << "accept";
			return 1;
		}
		else
		{
			std::cout << "Accepted connection" << std::endl;
			fflush( stdout );
			break;
		}
	}

	while( true )
	{
		if( ListenSocket( connect_sock ) != 0 )
			break;
	}

	closesocket( ssock );

	return 0;
}

int main()
{
	std::cout << "Sonify server listening" << std::endl;
	if( SocketThread() != 0 )
		std::cerr << "Socket failed somewhere" << std::endl;
	WSACleanup();

	return 0;
}
