function [classifiedsign, handdecision, headdecision]=HMMtest(targetsign, trajfile, shapefile, headfile, handsynthfile)
addpath(genpath('FullBNT'));
[alldHand] = readTrajShapeSEQ(trajfile, shapefile);
[alldHead] = readHeadSEQ(headfile);
%combine
alld.data = vertcellconcat(alldHand.data, alldHead.data);
alld.cls = 0;

%use HMMmodel to get the decision for the test example
load trHmmsContALL.mat;
num_gestures = length(model.prior.c);
%pre processing
nohandcount = 6;
transitioncount = 2;
[testseq] = transposecell(alld.data);
testseq = selectcellrows(testseq, featureindexvector);
handsynthdata = (testseq{1}(1:4,:))';
testseq = preprocesstrajectory(testseq, zerovalueindex, shapeindexstart, shapeindexend, nohandcount, transitioncount);
%original size is 640x480, down size it to 320x240
facehanddistance = (480 - testseq{1}(faceindexend-1,1))/2;
facemidx = ((testseq{1}(faceindexend,1)+testseq{1}(faceindexend-2,1))/2)/2;
numtotalframes = size(handsynthdata,1);
testseq = preprocessposition(testseq, faceindexstart, faceindexend);
testseq = preprocessheadmotion(testseq, faceindexstart, faceindexend, headmotionindexstart, headmotionindexend);
testseq = normalize_traj_leftright(testseq, maxindtonorm, [leftind;rightind]);
testseq = setstartpos(testseq,4);
% end of reading data & normalization

disp('Testing sequence...');
%test with Hand info
outmat = [];
I.c = cell(num_gestures,1);

llall = [];
for j=1:num_gestures
    %disp([num2str(i) ' - ' num2str(j)]);
    [loglik, errors, lls] = mhmm_logprob(testseq, model.prior.c{j}, model.tran.c{j}, model.mu.c{j}, model.sigma.c{j}, model.mixmat.c{j});
    llall=[llall lls'];
end
[LL, classifiedsignHand] = max(llall');
temp = [(classifiedsignHand)' llall];
outmatHand = [outmat; temp];

%test with Head info
%do not use the hand features
headfeatureindex = [headmotionindexstart headmotionindexstart+3:headmotionindexend];
V = length(headfeatureindex); %num coeffs in the vector
testseqHead = selectcellrows(testseq, headfeatureindex);
load trHmmsContHEAD.mat;

%test with Head info
outmat = [];
I.c = cell(num_gestures,1);

llall = [];
for j=1:num_gestures
    %disp([num2str(i) ' - ' num2str(j)]);
    [loglik, errors, lls] = mhmm_logprob(testseqHead, model.prior.c{j}, model.tran.c{j}, model.mu.c{j}, model.sigma.c{j}, model.mixmat.c{j});
    llall=[llall lls'];
end
[LL, classifiedsignHead] = max(llall');
temp = [(classifiedsignHead)' llall];
outmatHead = [outmat; temp];

%Combine likelihoods
load clusterinfo
modality{1} = outmatHand(2:end);
modality{2} = outmatHead(2:end);
[classifiedsign] = combine_classifiers_sequential(modality, numtocompare, clusterstocompare);

if (targetsign==classifiedsign)
    handdecision = 1;
    headdecision = 1;
elseif (targetsign==classifiedsignHand)
    handdecision = 1;
    headdecision = 0;
else
    handdecision = 0;
    headdecision = 0;        
end

dlmwrite(handsynthfile, [numtotalframes ceil(facehanddistance) classifiedsign facemidx ;handsynthdata], ',');
