function [labels] = combine_classifiers_sequential(classifiers, numtocompare, clusterstocompare)

numclassifiers = 2; % for now
numdata = size(classifiers{1},1);
numclasses = size(classifiers{1},2);
[sortedvalue, sortedindex] = sort((classifiers{1})','descend');
labels = (sortedindex(1,:))';
% calculate the number of classes to compare, use the first classifier 
%currently either 1, 2 or 3
for i=1:numdata
    groupavg = mean(sortedvalue(1:3,i));
    groupstd = std(sortedvalue(1:3,i));
    groupstdratio = abs(sortedvalue(1:3,i)-groupavg)./groupstd;
    if (nargin==1)
        numtocompare = 3;
        gap = find(groupstdratio>1.5);
        if (~isempty(gap))
            if ((gap(1)==1) || (gap(1)==2))
                numtocompare = 1;
            else %if (gap(1)==3)
                numtocompare = 2;
            end
        end
        % compare the likelihoods of the second classifier
        [val,ind] = max(classifiers{2}(i,sortedindex(1:numtocompare,i)));
        labels(i) = sortedindex(ind,i);
    elseif nargin==2 | isempty(clusterstocompare)
        [val,ind] = max(classifiers{2}(i,sortedindex(1:numtocompare(labels(i)),i)));
        labels(i) = sortedindex(ind,i);
    else
        [val,ind] = max(classifiers{2}(i,clusterstocompare{labels(i)}(1:numtocompare(labels(i)))));
        labels(i) = clusterstocompare{labels(i)}(ind);
    end
    
    
end