function [sc, xmedian, ymedian] = normalization_params_dep(data1, data2)
% joint normalization of two different feature sequences (i.e. left & right hands)
ymedian = 0;
xmedian = 0;
sc = 1;
if (size(data1,1)==2)
    %data(2,N) for x, y  coords of a trajectory of length N
    minx = min([data1(1,:) data2(1,:)]);
    miny = min([data1(2,:) data2(2,:)]);
    maxx = max([data1(1,:) data2(1,:)]);
    maxy = max([data1(2,:) data2(2,:)]);
    xmedian = (minx+maxx) / 2.0;
	ymedian = (miny+maxy) / 2.0;
	xsc = (maxx-minx) / 2.0;
	ysc = (maxy-miny) / 2.0;
	sc = max([xsc ysc]);
elseif size(data1,1)==1
    %data(1,N) any data of a trajectory of length N
    minx = min([data1(1,:) data2(1,:)]);
    maxx = max([data1(1,:) data2(1,:)]);
    xmedian = (minx+maxx) / 2.0;
	sc = (maxx-minx) / 2.0;
end

