function [ndata] = normalize_traj(alldata, maxindtonorm, dependents, st)
    %data{i,1}(V,T) V is the vector dim and T is the trajectory length
    numtraj = size(alldata,1);
    ndata = cell(numtraj,1);
    numdim = size(alldata{1,1},1);

    if nargin==2
        for i=1:numtraj
            for v = 1:2:maxindtonorm
                [sc, xmedian, ymedian] = normalization_params(alldata{i,1}(v:v+1,:));
                ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:)-xmedian)./sc; % x dim
                ndata{i}(v+1,:) = 0.50+0.50.*(alldata{i,1}(v+1,:)-ymedian)./sc; % y dim
            end
            for v = maxindtonorm+1:numdim
                [sc, md] = normalization_params(alldata{i,1}(v,:));
                if (sc)
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:)-md)./sc; 
                elseif (md)
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:))./md; 
                else
                    ndata{i}(v,:) = 0.50+0.50.*alldata{i,1}(v,:); 
                end
            end            
        end
    elseif nargin==3
        %%normalize trajectory -- left and right hand together
%         xmedian = zeros(size(dependents,1),1);
%         ymedian = zeros(size(dependents,1),1);
%         sc = zeros(size(dependents,1),1);
        xmedian = 0;
        ymedian = 0;
        sc = 0;
        for i=1:numtraj
            for d = 1:size(dependents,2)
                %find dependent params
                v1 = dependents(1,d)*2-1;
                v2 = dependents(2,d)*2-1;
                [sc, xmedian, ymedian] = normalization_params_dep(alldata{i,1}(v1:v1+1,:), alldata{i,1}(v2:v2+1,:)); %left
                %normalize
                ndata{i}(v1,:) = 0.50+0.50.*(alldata{i,1}(v1,:)-xmedian)./sc; % x dim
                ndata{i}(v1+1,:) = 0.50+0.50.*(alldata{i,1}(v1+1,:)-ymedian)./sc; % y dim
                ndata{i}(v2,:) = 0.50+0.50.*(alldata{i,1}(v2,:)-xmedian)./sc; % x dim
                ndata{i}(v2+1,:) = 0.50+0.50.*(alldata{i,1}(v2+1,:)-ymedian)./sc; % y dim                    
            end
            %group 2 normalization
            for v = maxindtonorm(1)+1:2:maxindtonorm(2)
                [sc, md] = normalization_params_dep(alldata{i,1}(v,:), alldata{i,1}(v+1,:));
                if (sc)
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:)-md)./sc; 
                    ndata{i}(v+1,:) = 0.50+0.50.*(alldata{i,1}(v+1,:)-md)./sc; 
                elseif (md)
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:))./md; 
                    ndata{i}(v+1,:) = 0.50+0.50.*(alldata{i,1}(v+1,:))./md; 
                else
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:)); 
                    ndata{i}(v+1,:) = 0.50+0.50.*(alldata{i,1}(v+1,:)); 
                end
            end
            %group 1 normalization
            for v = maxindtonorm(2)+1:2:maxindtonorm(3)
                [sc, md] = normalization_params(alldata{i,1}(v,:));
                if (sc)
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:)-md)./sc; 
                elseif (md)
                    ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:))./md; 
                else
                    ndata{i}(v,:) = 0.50+0.50.*alldata{i,1}(v,:); 
                end
            end                        
            %no normalization
            for v = maxindtonorm(3)+1:numdim            
                ndata{i}(v,:) = (alldata{i,1}(v,:)); 
            end
        end
    elseif nargin==4
        mn = dependents;
        for i=1:numtraj
            for v = 1:2:maxindtonorm
                [sc, xmedian, ymedian] = normalization_params(alldata{i,1}(v:v+1,:));
                ndata{i}(v,:) = 0.50+0.50.*(alldata{i,1}(v,:)-xmedian)./sc; % x dim
                ndata{i}(v+1,:) = 0.50+0.50.*(alldata{i,1}(v+1,:)-ymedian)./sc; % y dim
            end
            [tmpdata] = normztrunc(alldata{i,1}(maxindtonorm+1:numdim,:)', -1, mn, st);
            ndata{i}(maxindtonorm+1:numdim,:) = tmpdata';
        end
    end