function [Xz, mn, st] = normztrunc (X,M, mn, st)

% NORMZTRUNC z-normalize (and optionally truncate) data
% Xz = normztrunc (X,M)
%  
% X is N x D matrix with N D-dimensional vectors
% M is a small positive integer - if it is supplied then all
%   normalized z-values are truncated so that they are between
%   -M and M (this reduces the effect of outliers - but for very
%   large outliers you might want to run this twice, i.e.
%   saying "Xz = normztrunc(normztrunc(X,M),M);"
% mn and st are vectors of size D and represents mean and std of 
%   each dimension. If these parameters are given, mean and std 
%   are not calculated from data, parameters are used instead

Xz = zeros(size(X));

if nargin==1        % if second argument not supplied then dont truncate
  M=-1;
end
if nargin==0
    disp('Not enough parameters!');
    return;
end
if nargin<=2
	[N,D]=size(X);
	for d=1:D
	  mn(d)=mean(X(:,d));
	  st(d)=sqrt(var(X(:,d)));
	  if (st(d))
	    Xz(:,d) = (X(:,d)-mn(d)) / st(d);
	  elseif mn(d)
	    Xz(:,d) = X(:,d) / mn(d);         % if all values in dimension are the same, just divide by mean
	  else
	    Xz(:,d) = X(:,d);             % unless its zero (in which case this is a dimension with only 0 values)
	  end
	end
	
	if M>0
	  Xz = min(M,max(-M,Xz));
	end
elseif nargin==4
	[N,D]=size(X);
	for d=1:D
	  if (st(d))
	    Xz(:,d) = (X(:,d)-mn(d)) / st(d);
	  elseif mn(d)
	    Xz(:,d) = X(:,d) / mn(d);         % if all values in dimension are the same, just divide by mean
	  else
	    Xz(:,d) = X(:,d);             % unless its zero (in which case this is a dimension with only 0 values)
	  end
	end
	
	if M>0
	  Xz = min(M,max(-M,Xz));
	end
	
else
	disp('Wrong number of parameters');
end

