function ptraj = preprocessheadmotion(traj, faceindexstart, faceindexend, headmotionindexstart, headmotionindexend)
dxleft = faceindexstart;
dyleft = faceindexstart+1;
dxright = faceindexstart+2;
dyright = faceindexstart+3;
dist = 0.5/10;
alpha = 0.5;
num_traj = size(traj,1);
ptraj = cell(num_traj, 1);
% if distance to face (dx or dy) is less than dist, hand is in front of the face
for (t = 1:num_traj)
	tempArr = traj{t,1};
	num_points = size(tempArr,2);
    num_features = size(tempArr,1);
	for j=1:num_points
        %tempArr(headmotionindexstart:headmotionindexstart+3-1,j) = ;
        for k=headmotionindexstart:headmotionindexstart+3-1
            tempArr(k,j) = min(1, tempArr(k,j) / (1*(10^13)));
        end
        tempArr(headmotionindexend-1:headmotionindexend,j) = abs(tempArr(headmotionindexend-1:headmotionindexend,j));
        if (j>1 & ...
            ((abs(tempArr(dxleft,j))<dist & abs(tempArr(dyleft,j))<dist) |...
            (abs(tempArr(dxright,j))<dist & abs(tempArr(dyright,j))<dist)))
            tempArr(headmotionindexstart:headmotionindexend,j) = 0;%tempArr(headmotionindexstart:headmotionindexend,j-1);
        end
        if (j>1)
            % apply adaptive smoothing
                tempArr(headmotionindexstart:headmotionindexend,j) = ...
                    alpha * tempArr(headmotionindexstart:headmotionindexend,j) + ...
                    (1-alpha) * tempArr(headmotionindexstart:headmotionindexend,j-1);
        else
                %tempArr(headmotionindexstart:headmotionindexend,j) = 0;
        end
    end
    ptraj{t,1} = tempArr;
end